/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InvokeFunctionBytecodeExpression;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RowToRowCast
extends SqlOperator {
    public static final RowToRowCast ROW_TO_ROW_CAST = new RowToRowCast();

    private RowToRowCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound("F", "row"), (Object)Signature.withVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"F")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        if (fromType.getTypeParameters().size() != toType.getTypeParameters().size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "the size of fromType and toType must match");
        }
        Class<?> castOperatorClass = RowToRowCast.generateRowCast(fromType, toType, functionRegistry);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castRow", ConnectorSession.class, Block.class);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    private static Class<?> generateRowCast(Type fromType, Type toType, FunctionRegistry functionRegistry) {
        List toTypes = toType.getTypeParameters();
        List fromTypes = fromType.getTypeParameters();
        CallSiteBinder binder = new CallSiteBinder();
        byte[] md5Suffix = Hashing.md5().hashBytes((fromType + "$" + toType).getBytes()).asBytes();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)Joiner.on((String)"$").join((Object)"RowCast", (Object)BaseEncoding.base16().encode(md5Suffix), new Object[0])), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter value = Parameter.arg((String)"value", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "castRow", ParameterizedType.type(Block.class), new Parameter[]{session, value});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Variable singleRowBlockWriter = scope.createTempVariable(BlockBuilder.class);
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false)));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        body.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, toType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0]), BytecodeExpressions.constantInt((int)1)})));
        body.append((BytecodeNode)singleRowBlockWriter.set(blockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        for (int i = 0; i < toTypes.size(); ++i) {
            Signature signature = Signature.internalOperator(OperatorType.CAST.name(), ((Type)toTypes.get(i)).getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)((Type)fromTypes.get(i)).getTypeSignature()));
            ScalarFunctionImplementation function = functionRegistry.getScalarFunctionImplementation(signature);
            Type currentFromType = (Type)fromTypes.get(i);
            if (currentFromType.equals((Object)UnknownType.UNKNOWN)) {
                body.append((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
                continue;
            }
            BytecodeExpression fromElement = SqlTypeBytecodeExpression.constantType(binder, currentFromType).getValue((BytecodeExpression)value, BytecodeExpressions.constantInt((int)i));
            BytecodeExpression toElement = InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, signature.getName(), function, fromElement);
            IfStatement ifElementNull = new IfStatement("if the element in the row type is null...", new Object[0]);
            ifElementNull.condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})).ifTrue((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, (Type)toTypes.get(i)).writeValue((BytecodeExpression)singleRowBlockWriter, toElement));
            body.append((BytecodeNode)ifElementNull);
        }
        body.append((BytecodeNode)blockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, toType).invoke("getObject", Object.class, new BytecodeExpression[]{blockBuilder.cast(Block.class), BytecodeExpressions.constantInt((int)0)}).cast(Block.class).ret());
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass((ClassDefinition)definition, Object.class, binder.getBindings(), (ClassLoader)RowToRowCast.class.getClassLoader());
    }
}

