/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class ConcatFunction
extends SqlScalarFunction {
    public static final ConcatFunction VARCHAR_CONCAT = new ConcatFunction(VarcharType.createUnboundedVarcharType().getTypeSignature(), "concatenates given strings");
    public static final ConcatFunction VARBINARY_CONCAT = new ConcatFunction(VarbinaryType.VARBINARY.getTypeSignature(), "concatenates given varbinary values");
    private String description;

    private ConcatFunction(TypeSignature type, String description) {
        super(new Signature("concat", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), type, (List<TypeSignature>)ImmutableList.of((Object)type), true));
        this.description = description;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        Class<?> clazz = ConcatFunction.generateConcat(this.getSignature().getReturnType(), arity);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "concat", Collections.nCopies(arity, Slice.class).toArray(new Class[arity]));
        return new ScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    private static Class<?> generateConcat(TypeSignature type, int arity) {
        Failures.checkCondition(arity <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for string concatenation", new Object[0]);
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)(type.getBase() + "_concat" + arity + "ScalarFunction")), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, arity).mapToObj(i -> Parameter.arg((String)("arg" + i), Slice.class)).collect(ImmutableList.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "concat", ParameterizedType.type(Slice.class), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable length = scope.declareVariable(Integer.TYPE, "length");
        body.append((BytecodeNode)length.set(BytecodeExpressions.constantInt((int)0)));
        for (int i2 = 0; i2 < arity; ++i2) {
            body.append((BytecodeNode)length.set(ConcatFunction.generateCheckedAdd((BytecodeExpression)length, ((Parameter)parameters.get(i2)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        Variable result = scope.declareVariable(Slice.class, "result");
        body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(Slices.class, (String)"allocate", Slice.class, (BytecodeExpression[])new BytecodeExpression[]{length})));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0)));
        for (int i3 = 0; i3 < arity; ++i3) {
            body.append((BytecodeNode)result.invoke("setBytes", Void.TYPE, new BytecodeExpression[]{position, (BytecodeExpression)parameters.get(i3)}));
            body.append((BytecodeNode)position.set(BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)((Parameter)parameters.get(i3)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        body.getVariable(result).retObject();
        return CompilerUtils.defineClass((ClassDefinition)definition, Object.class, (Map)ImmutableMap.of(), (ClassLoader)new DynamicClassLoader(ConcatFunction.class.getClassLoader()));
    }

    private static BytecodeExpression generateCheckedAdd(BytecodeExpression x, BytecodeExpression y) {
        return BytecodeExpressions.invokeStatic(ConcatFunction.class, (String)"checkedAdd", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{x, y});
    }

    @UsedByGeneratedCode
    public static int checkedAdd(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
    }
}

