/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.atomic.AtomicBoolean;

@ScalarFunction(value="array_union")
@Description(value="Union elements of the two given arrays")
public final class ArrayUnionFunction {
    private ArrayUnionFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block union(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        TypedSet typedSet = new TypedSet(type, leftArrayCount + rightArrayCount, "array_union");
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), leftArrayCount + rightArrayCount);
        ArrayUnionFunction.appendTypedArray(leftArray, type, typedSet, distinctElementBlockBuilder);
        ArrayUnionFunction.appendTypedArray(rightArray, type, typedSet, distinctElementBlockBuilder);
        return distinctElementBlockBuilder.build();
    }

    private static void appendTypedArray(Block array, Type type, TypedSet typedSet, BlockBuilder blockBuilder) {
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            type.appendTo(array, i, blockBuilder);
        }
    }

    @SqlType(value="array(bigint)")
    public static Block bigintUnion(@SqlType(value="array(bigint)") Block leftArray, @SqlType(value="array(bigint)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        LongOpenHashSet set = new LongOpenHashSet(leftArrayCount + rightArrayCount);
        BlockBuilder distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), leftArrayCount + rightArrayCount);
        AtomicBoolean containsNull = new AtomicBoolean(false);
        ArrayUnionFunction.appendBigintArray(leftArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        ArrayUnionFunction.appendBigintArray(rightArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        return distinctElementBlockBuilder.build();
    }

    private static void appendBigintArray(Block array, AtomicBoolean containsNull, LongSet set, BlockBuilder blockBuilder) {
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull.get()) continue;
                containsNull.set(true);
                blockBuilder.appendNull();
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (!set.add(value)) continue;
            BigintType.BIGINT.writeLong(blockBuilder, value);
        }
    }
}

