/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

public final class ArrayMinMaxUtils {
    private ArrayMinMaxUtils() {
    }

    @UsedByGeneratedCode
    public static Long longArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            long selectedValue = elementType.getLong(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                long value = elementType.getLong(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @UsedByGeneratedCode
    public static Boolean booleanArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            boolean selectedValue = elementType.getBoolean(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                boolean value = elementType.getBoolean(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @UsedByGeneratedCode
    public static Double doubleArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            double selectedValue = elementType.getDouble(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                double value = elementType.getDouble(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @UsedByGeneratedCode
    public static Slice sliceArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Slice selectedValue = elementType.getSlice(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Slice value = elementType.getSlice(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

