/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayFlattenFunction
extends SqlScalarFunction {
    public static final ArrayFlattenFunction ARRAY_FLATTEN_FUNCTION = new ArrayFlattenFunction();
    private static final String FUNCTION_NAME = "flatten";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFlattenFunction.class, "flatten", Type.class, Type.class, Block.class);

    private ArrayFlattenFunction() {
        super(new Signature(FUNCTION_NAME, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(E)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(array(E))")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Flattens the given array";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type elementType = boundVariables.getTypeVariable("E");
        Type arrayType = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(elementType).bindTo(arrayType);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    public static Block flatten(Type type, Type arrayType, Block array) {
        if (array.getPositionCount() == 0) {
            return type.createBlockBuilder(new BlockBuilderStatus(), 0).build();
        }
        BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus(), array.getPositionCount(), Math.toIntExact(array.getSizeInBytes() / (long)array.getPositionCount()));
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) continue;
            Block subArray = (Block)arrayType.getObject(array, i);
            for (int j = 0; j < subArray.getPositionCount(); ++j) {
                type.appendTo(subArray, j, builder);
            }
        }
        return builder.build();
    }
}

