/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractGreatestLeast
extends SqlScalarFunction {
    private static final MethodHandle CHECK_NOT_NAN = Reflection.methodHandle(AbstractGreatestLeast.class, "checkNotNaN", String.class, Double.TYPE);
    private final OperatorType operatorType;

    protected AbstractGreatestLeast(String name, OperatorType operatorType) {
        super(new Signature(name, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"E"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"E")), true));
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = boundVariables.getTypeVariable("E");
        Preconditions.checkArgument((boolean)type.isOrderable(), (Object)"Type must be orderable");
        MethodHandle compareMethod = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(this.operatorType, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        List javaTypes = (List)IntStream.range(0, arity).mapToObj(i -> type.getJavaType()).collect(ImmutableList.toImmutableList());
        Class<?> clazz = this.generate(javaTypes, type, compareMethod);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, this.getSignature().getName(), javaTypes.toArray(new Class[javaTypes.size()]));
        return new ScalarFunctionImplementation(false, Collections.nCopies(javaTypes.size(), ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static void checkNotNaN(String name, double value) {
        if (Double.isNaN(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid argument to %s(): NaN", name));
        }
    }

    private Class<?> generate(List<Class<?>> javaTypes, Type type, MethodHandle compareMethod) {
        Failures.checkCondition(javaTypes.size() <= 127, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for function call %s()", this.getSignature().getName());
        String javaTypeName = javaTypes.stream().map(Class::getSimpleName).collect(Collectors.joining());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)(javaTypeName + "$" + this.getSignature().getName())), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, javaTypes.size()).mapToObj(i -> Parameter.arg((String)("arg" + i), (Class)((Class)javaTypes.get(i)))).collect(ImmutableList.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), this.getSignature().getName(), ParameterizedType.type(javaTypes.get(0)), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        CallSiteBinder binder = new CallSiteBinder();
        if (type.getTypeSignature().getBase().equals("double")) {
            for (Parameter parameter : parameters) {
                body.append((BytecodeNode)parameter);
                body.append((BytecodeNode)BytecodeUtils.invoke(binder.bind(CHECK_NOT_NAN.bindTo(this.getSignature().getName())), "checkNotNaN"));
            }
        }
        Variable value = scope.declareVariable(javaTypes.get(0), "value");
        body.append((BytecodeNode)value.set((BytecodeExpression)parameters.get(0)));
        for (int i2 = 1; i2 < javaTypes.size(); ++i2) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)parameters.get(i2)).append((BytecodeNode)value).append((BytecodeNode)BytecodeUtils.invoke(binder.bind(compareMethod), "compare"))).ifTrue((BytecodeNode)value.set((BytecodeExpression)parameters.get(i2))));
        }
        body.append((BytecodeNode)value.ret());
        return CompilerUtils.defineClass((ClassDefinition)definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(this.getClass().getClassLoader()));
    }
}

