/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionOutput;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InputPageProjection
implements PageProjection {
    private final Type type;
    private final InputChannels inputChannels;

    public InputPageProjection(int inputChannel, Type type) {
        this.type = type;
        this.inputChannels = new InputChannels(inputChannel);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public PageProjectionOutput project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new InputPageProjectionOutput(page, selectedPositions);
    }

    private class InputPageProjectionOutput
    implements PageProjectionOutput {
        private final Block block;
        private final SelectedPositions selectedPositions;

        public InputPageProjectionOutput(Page page, SelectedPositions selectedPositions) {
            this.block = Objects.requireNonNull(page, "page is null").getBlock(0);
            this.selectedPositions = Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        }

        @Override
        public Optional<Block> compute() {
            if (this.selectedPositions.isList()) {
                List positionList = Ints.asList((int[])this.selectedPositions.getPositions()).subList(this.selectedPositions.getOffset(), this.selectedPositions.getOffset() + this.selectedPositions.size());
                return Optional.of(this.block.copyPositions(positionList));
            }
            return Optional.of(this.block.getRegion(this.selectedPositions.getOffset(), this.selectedPositions.size()));
        }
    }
}

