/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionOutput;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class GeneratedPageProjection
implements PageProjection {
    private final RowExpression projection;
    private final boolean isDeterministic;
    private final InputChannels inputChannels;
    private final MethodHandle pageProjectionOutputFactory;
    private BlockBuilder blockBuilder;

    public GeneratedPageProjection(RowExpression projection, boolean isDeterministic, InputChannels inputChannels, MethodHandle pageProjectionOutputFactory) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.isDeterministic = isDeterministic;
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
        this.pageProjectionOutputFactory = Objects.requireNonNull(pageProjectionOutputFactory, "pageProjectionOutputFactory is null");
        this.blockBuilder = projection.getType().createBlockBuilder(new BlockBuilderStatus(), 1);
    }

    @Override
    public Type getType() {
        return this.projection.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public PageProjectionOutput project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        this.blockBuilder = this.blockBuilder.newBlockBuilderLike(new BlockBuilderStatus());
        try {
            return this.pageProjectionOutputFactory.invoke(this.blockBuilder, session, yieldSignal, page, selectedPositions);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projection", (Object)this.projection).toString();
    }
}

