/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionOutput;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ConstantPageProjection
implements PageProjection {
    private static final InputChannels INPUT_PARAMETERS = new InputChannels((List<Integer>)ImmutableList.of());
    private final Type type;
    private final Block value;

    public ConstantPageProjection(Object value, Type type) {
        this.type = type;
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1);
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        this.value = blockBuilder.build();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return INPUT_PARAMETERS;
    }

    @Override
    public PageProjectionOutput project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new ConstantPageProjectionOutput(this.value, selectedPositions.size());
    }

    private class ConstantPageProjectionOutput
    implements PageProjectionOutput {
        private final Block value;
        private final int size;

        public ConstantPageProjectionOutput(Block value, int size) {
            this.value = value;
            this.size = size;
        }

        @Override
        public Optional<Block> compute() {
            return Optional.of(new RunLengthEncodedBlock(this.value, this.size));
        }
    }
}

