/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateRequest {
    private final Block[] blocks;
    private final SettableFuture<IndexSnapshot> indexSnapshotFuture = SettableFuture.create();
    private final Page page;

    public UpdateRequest(Block ... blocks) {
        this.blocks = Objects.requireNonNull(blocks, "blocks is null");
        this.page = new Page(blocks);
    }

    @Deprecated
    public Block[] getBlocks() {
        return this.blocks;
    }

    public Page getPage() {
        return this.page;
    }

    public void finished(IndexSnapshot indexSnapshot) {
        Objects.requireNonNull(indexSnapshot, "indexSnapshot is null");
        Preconditions.checkState((boolean)this.indexSnapshotFuture.set((Object)indexSnapshot), (Object)"Already finished!");
    }

    public void failed(Throwable throwable) {
        this.indexSnapshotFuture.setException(throwable);
    }

    public boolean isFinished() {
        return this.indexSnapshotFuture.isDone();
    }

    public IndexSnapshot getFinishedIndexSnapshot() {
        Preconditions.checkState((boolean)this.indexSnapshotFuture.isDone(), (Object)"Update request is not finished");
        return (IndexSnapshot)MoreFutures.getFutureValue(this.indexSnapshotFuture);
    }
}

