/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceProvider;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.StaticLookupSourceProvider;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexLookupSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;

public class IndexLookupSourceFactory
implements LookupSourceFactory {
    private final List<Type> outputTypes;
    private final Map<Symbol, Integer> layout;
    private final Supplier<IndexLoader> indexLoaderSupplier;
    private TaskContext taskContext;

    public IndexLookupSourceFactory(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, OptionalInt keyOutputHashChannel, List<Type> outputTypes, Map<Symbol, Integer> layout, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, DataSize maxIndexMemorySize, IndexJoinLookupStats stats, boolean shareIndexLoading, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler) {
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        this.layout = ImmutableMap.copyOf(Objects.requireNonNull(layout, "layout is null"));
        if (shareIndexLoading) {
            IndexLoader shared = new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats, pagesIndexFactory, joinCompiler);
            this.indexLoaderSupplier = () -> shared;
        } else {
            this.indexLoaderSupplier = () -> new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats, pagesIndexFactory, joinCompiler);
        }
    }

    @Override
    public List<Type> getTypes() {
        return this.outputTypes;
    }

    @Override
    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    @Override
    public Map<Symbol, Integer> getLayout() {
        return this.layout;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public ListenableFuture<LookupSourceProvider> createLookupSourceProvider() {
        Preconditions.checkState((this.taskContext != null ? 1 : 0) != 0, (Object)"taskContext not set");
        IndexLoader indexLoader = this.indexLoaderSupplier.get();
        indexLoader.setContext(this.taskContext);
        return Futures.immediateFuture((Object)new StaticLookupSourceProvider(new IndexLookupSource(indexLoader)));
    }

    @Override
    public int partitions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OuterPositionIterator getOuterPositionIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
    }
}

