/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;

public class LocalExchangeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalExchangeSource source;

    public LocalExchangeSourceOperator(OperatorContext operatorContext, LocalExchangeSource source) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.source = Objects.requireNonNull(source, "source is null");
        operatorContext.setInfoSupplier(source::getBufferInfo);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.source.getTypes();
    }

    @Override
    public void finish() {
        this.source.finish();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.source.waitForReading();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.source.removePage();
        if (page != null) {
            this.operatorContext.recordGeneratedInput(page.getSizeInBytes(), page.getPositionCount());
        }
        return page;
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static class LocalExchangeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final LocalExchange inMemoryExchange;
        private int bufferIndex;
        private boolean closed;

        public LocalExchangeSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, LocalExchange inMemoryExchange) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.inMemoryExchange = Objects.requireNonNull(inMemoryExchange, "inMemoryExchange is null");
        }

        @Override
        public List<Type> getTypes() {
            return this.inMemoryExchange.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            Preconditions.checkState((this.bufferIndex < this.inMemoryExchange.getBufferCount() ? 1 : 0) != 0, (Object)"All operators already created");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalExchangeSourceOperator.class.getSimpleName());
            LocalExchangeSourceOperator operator = new LocalExchangeSourceOperator(operatorContext, this.inMemoryExchange.getSource(this.bufferIndex));
            ++this.bufferIndex;
            return operator;
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories can not be duplicated");
        }
    }
}

