/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

class BroadcastExchanger
implements Consumer<Page> {
    private final List<Consumer<PageReference>> buffers;
    private final LongConsumer memoryTracker;

    public BroadcastExchanger(List<Consumer<PageReference>> buffers, LongConsumer memoryTracker) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
    }

    @Override
    public void accept(Page page) {
        this.memoryTracker.accept(page.getRetainedSizeInBytes());
        PageReference pageReference = new PageReference(page, this.buffers.size(), () -> this.memoryTracker.accept(-page.getRetainedSizeInBytes()));
        for (Consumer<PageReference> buffer : this.buffers) {
            buffer.accept(pageReference);
        }
    }
}

