/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ArrayAggregationStateFactory
implements AccumulatorStateFactory<ArrayAggregationState> {
    public ArrayAggregationState createSingleState() {
        return new SingleArrayAggregationState();
    }

    public Class<? extends ArrayAggregationState> getSingleStateClass() {
        return SingleArrayAggregationState.class;
    }

    public ArrayAggregationState createGroupedState() {
        return new GroupedArrayAggregationState();
    }

    public Class<? extends ArrayAggregationState> getGroupedStateClass() {
        return GroupedArrayAggregationState.class;
    }

    public static class SingleArrayAggregationState
    implements ArrayAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleArrayAggregationState.class).instanceSize();
        private BlockBuilder blockBuilder;

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.blockBuilder != null) {
                estimatedSize += this.blockBuilder.getRetainedSizeInBytes();
            }
            return estimatedSize;
        }

        @Override
        public BlockBuilder getBlockBuilder() {
            return this.blockBuilder;
        }

        @Override
        public void setBlockBuilder(BlockBuilder value) {
            Objects.requireNonNull(value, "value is null");
            this.blockBuilder = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedArrayAggregationState
    extends AbstractGroupedAccumulatorState
    implements ArrayAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedArrayAggregationState.class).instanceSize();
        private final ObjectBigArray<BlockBuilder> blockBuilders = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.blockBuilders.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.blockBuilders.sizeOf();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public BlockBuilder getBlockBuilder() {
            return (BlockBuilder)this.blockBuilders.get(this.getGroupId());
        }

        @Override
        public void setBlockBuilder(BlockBuilder value) {
            Objects.requireNonNull(value, "value is null");
            BlockBuilder previous = this.getBlockBuilder();
            if (previous != null) {
                this.size -= previous.getRetainedSizeInBytes();
            }
            this.blockBuilders.set(this.getGroupId(), (Object)value);
            this.size += value.getRetainedSizeInBytes();
        }
    }
}

