/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public class DecimalAverageAggregation
extends SqlAggregationFunction {
    public static final DecimalAverageAggregation DECIMAL_AVERAGE_AGGREGATION = new DecimalAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputShortDecimal", Type.class, LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputLongDecimal", Type.class, LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle SHORT_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputShortDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "combine", LongDecimalWithOverflowAndLongState.class, LongDecimalWithOverflowAndLongState.class);
    private static final BigInteger TWO = new BigInteger("2");

    public DecimalAverageAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s")), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))));
    }

    @Override
    public String getDescription() {
        return "Calculates the average value";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = typeManager.getType((TypeSignature)Iterables.getOnlyElement(SignatureBinder.applyBoundVariables(this.getSignature().getArgumentTypes(), boundVariables)));
        return DecimalAverageAggregation.generateAggregation(type);
    }

    private static InternalAggregationFunction generateAggregation(Type type) {
        MethodHandle outputFunction;
        MethodHandle inputFunction;
        Preconditions.checkArgument((boolean)(type instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalAverageAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        Class<LongDecimalWithOverflowAndLongState> stateInterface = LongDecimalWithOverflowAndLongState.class;
        LongDecimalWithOverflowAndLongStateSerializer stateSerializer = new LongDecimalWithOverflowAndLongStateSerializer();
        if (((DecimalType)type).isShort()) {
            inputFunction = SHORT_DECIMAL_INPUT_FUNCTION;
            outputFunction = SHORT_DECIMAL_OUTPUT_FUNCTION;
        } else {
            inputFunction = LONG_DECIMAL_INPUT_FUNCTION;
            outputFunction = LONG_DECIMAL_OUTPUT_FUNCTION;
        }
        inputFunction = inputFunction.bindTo(type);
        outputFunction = outputFunction.bindTo(type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalAverageAggregation.createInputParameterMetadata(type), inputFunction, COMBINE_FUNCTION, outputFunction, stateInterface, stateSerializer, new LongDecimalWithOverflowAndLongStateFactory(), type);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, type, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(Type type, LongDecimalWithOverflowAndLongState state, Block block, int position) {
        DecimalAverageAggregation.accumulateValueInState(UnscaledDecimal128Arithmetic.unscaledDecimal((long)type.getLong(block, position)), state);
    }

    public static void inputLongDecimal(Type type, LongDecimalWithOverflowAndLongState state, Block block, int position) {
        DecimalAverageAggregation.accumulateValueInState(type.getSlice(block, position), state);
    }

    private static void accumulateValueInState(Slice unscaledValue, LongDecimalWithOverflowAndLongState state) {
        DecimalAverageAggregation.accumulateAndUpdateOverflow(unscaledValue, state);
        state.setLong(state.getLong() + 1L);
    }

    private static void initializeIfNeeded(LongDecimalWithOverflowAndLongState state) {
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(UnscaledDecimal128Arithmetic.unscaledDecimal());
        }
    }

    public static void combine(LongDecimalWithOverflowAndLongState state, LongDecimalWithOverflowAndLongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setOverflow(state.getOverflow() + otherState.getOverflow());
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(otherState.getLongDecimal());
        } else {
            DecimalAverageAggregation.accumulateAndUpdateOverflow(otherState.getLongDecimal(), state);
        }
    }

    public static void outputShortDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            Decimals.writeShortDecimal((BlockBuilder)out, (long)DecimalAverageAggregation.average(state, type).unscaledValue().longValueExact());
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            Decimals.writeBigDecimal((DecimalType)type, (BlockBuilder)out, (BigDecimal)DecimalAverageAggregation.average(state, type));
        }
    }

    @VisibleForTesting
    public static BigDecimal average(LongDecimalWithOverflowAndLongState state, DecimalType type) {
        BigDecimal sum = new BigDecimal(Decimals.decodeUnscaledValue((Slice)state.getLongDecimal()), type.getScale());
        BigDecimal count = BigDecimal.valueOf(state.getLong());
        if (state.getOverflow() != 0L) {
            BigInteger overflowMultiplier = TWO.shiftLeft(126);
            BigInteger overflow = overflowMultiplier.multiply(BigInteger.valueOf(state.getOverflow()));
            sum = sum.add(new BigDecimal(overflow));
        }
        return sum.divide(count, type.getScale(), 4);
    }

    private static void accumulateAndUpdateOverflow(Slice unscaledValue, LongDecimalWithOverflowAndLongState state) {
        DecimalAverageAggregation.initializeIfNeeded(state);
        Slice sum = state.getLongDecimal();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)unscaledValue, (Slice)sum);
        state.setOverflow(state.getOverflow() + overflow);
    }
}

