/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import java.util.List;

public class TwoChannelJoinProbe
implements JoinProbe {
    private final int positionCount;
    private final Type typeA;
    private final Type typeB;
    private final Block blockA;
    private final Block blockB;
    private final Block probeBlockA;
    private final Block probeBlockB;
    private final Block[] probeBlocks;
    private final Page page;
    private final Page probePage;
    private int position = -1;

    public TwoChannelJoinProbe(List<Type> types, Page page) {
        this.positionCount = page.getPositionCount();
        this.typeA = types.get(0);
        this.typeB = types.get(1);
        this.blockA = page.getBlock(0);
        this.blockB = page.getBlock(1);
        this.probeBlockA = this.blockA;
        this.probeBlockB = this.blockB;
        this.probeBlocks = new Block[2];
        this.probeBlocks[0] = this.probeBlockA;
        this.probeBlocks[1] = this.probeBlockB;
        this.page = page;
        this.probePage = new Page(this.probeBlocks);
    }

    @Override
    public int getOutputChannelCount() {
        return 2;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        this.typeA.appendTo(this.blockA, this.position, pageBuilder.getBlockBuilder(0));
        this.typeB.appendTo(this.blockB, this.position, pageBuilder.getBlockBuilder(1));
    }

    @Override
    public boolean advanceNextPosition() {
        ++this.position;
        return this.position < this.positionCount;
    }

    @Override
    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    private boolean currentRowContainsNull() {
        if (this.probeBlockA.isNull(this.position)) {
            return true;
        }
        return this.probeBlockB.isNull(this.position);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    public static class TwoChannelJoinProbeFactory
    implements JoinProbeFactory {
        private final List<Type> types;

        public TwoChannelJoinProbeFactory(List<Type> types) {
            this.types = types;
        }

        @Override
        public JoinProbe createJoinProbe(Page page) {
            return new TwoChannelJoinProbe(this.types, page);
        }
    }
}

