/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TableWriterOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    private final LocalMemoryContext pageSinkMemoryContext;
    private final ConnectorPageSink pageSink;
    private final List<Integer> inputChannels;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private CompletableFuture<Collection<Slice>> finishFuture;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;

    public TableWriterOperator(OperatorContext operatorContext, ConnectorPageSink pageSink, List<Integer> inputChannels) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageSinkMemoryContext = operatorContext.getSystemMemoryContext().newLocalMemoryContext();
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = this.pageSink.finish();
            this.blocked = MoreFutures.toListenableFuture(this.finishFuture);
        }
    }

    @Override
    public boolean isFinished() {
        this.updateBlockedIfNecessary();
        return this.state == State.FINISHED && this.blocked == NOT_BLOCKED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        this.updateBlockedIfNecessary();
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        this.updateBlockedIfNecessary();
        return this.state == State.RUNNING && this.blocked == NOT_BLOCKED;
    }

    private void updateBlockedIfNecessary() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator does not need input");
        Block[] blocks = new Block[this.inputChannels.size()];
        for (int outputChannel = 0; outputChannel < this.inputChannels.size(); ++outputChannel) {
            blocks[outputChannel] = page.getBlock(this.inputChannels.get(outputChannel).intValue());
        }
        CompletableFuture future = this.pageSink.appendPage(new Page(blocks));
        this.pageSinkMemoryContext.setBytes(this.pageSink.getSystemMemoryUsage());
        if (!future.isDone()) {
            this.blocked = MoreFutures.toListenableFuture((CompletableFuture)future);
        }
        this.rowCount += (long)page.getPositionCount();
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.blocked.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        this.committed = true;
        PageBuilder page = new PageBuilder(TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                this.pageSink.abort();
            }
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.WriterTarget target;
        private final List<Integer> inputChannels;
        private final Session session;
        private boolean closed;

        public TableWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, TableWriterNode.WriterTarget writerTarget, List<Integer> inputChannels, Session session) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            Preconditions.checkArgument((writerTarget instanceof TableWriterNode.CreateHandle || writerTarget instanceof TableWriterNode.InsertHandle ? 1 : 0) != 0, (Object)"writerTarget must be CreateHandle or InsertHandle");
            this.target = Objects.requireNonNull(writerTarget, "writerTarget is null");
            this.session = session;
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableWriterOperator.class.getSimpleName());
            return new TableWriterOperator(context, this.createPageSink(), this.inputChannels);
        }

        private ConnectorPageSink createPageSink() {
            if (this.target instanceof TableWriterNode.CreateHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.CreateHandle)this.target).getHandle());
            }
            if (this.target instanceof TableWriterNode.InsertHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.InsertHandle)this.target).getHandle());
            }
            throw new UnsupportedOperationException("Unhandled target type: " + this.target.getClass().getName());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.target, this.inputChannels, this.session);
        }
    }
}

