/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class SimpleJoinProbe
implements JoinProbe {
    private final List<Type> types;
    private final List<Integer> probeOutputChannels;
    private final int positionCount;
    private final Block[] blocks;
    private final Block[] probeBlocks;
    private final Page page;
    private final Page probePage;
    private final Optional<Block> probeHashBlock;
    private int position = -1;

    private SimpleJoinProbe(List<Type> types, List<Integer> probeOutputChannels, Page page, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
        int i;
        this.types = types;
        this.probeOutputChannels = probeOutputChannels;
        this.positionCount = page.getPositionCount();
        this.blocks = new Block[page.getChannelCount()];
        this.probeBlocks = new Block[probeJoinChannels.size()];
        for (i = 0; i < page.getChannelCount(); ++i) {
            this.blocks[i] = page.getBlock(i);
        }
        for (i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeBlocks[i] = this.blocks[probeJoinChannels.get(i)];
        }
        this.page = page;
        this.probePage = new Page(page.getPositionCount(), this.probeBlocks);
        this.probeHashBlock = probeHashChannel.isPresent() ? Optional.of(page.getBlock(probeHashChannel.getAsInt())) : Optional.empty();
    }

    @Override
    public int getOutputChannelCount() {
        return this.probeOutputChannels.size();
    }

    @Override
    public boolean advanceNextPosition() {
        ++this.position;
        return this.position < this.positionCount;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        int pageBuilderOutputChannel = 0;
        for (int outputIndex : this.probeOutputChannels) {
            Type type = this.types.get(outputIndex);
            Block block = this.blocks[outputIndex];
            type.appendTo(block, this.position, pageBuilder.getBlockBuilder(pageBuilderOutputChannel++));
        }
    }

    @Override
    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock.isPresent()) {
            long rawHash = BigintType.BIGINT.getLong(this.probeHashBlock.get(), this.position);
            return lookupSource.getJoinPosition(this.position, this.probePage, this.page, rawHash);
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    private boolean currentRowContainsNull() {
        for (Block probeBlock : this.probeBlocks) {
            if (!probeBlock.isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    public static class SimpleJoinProbeFactory
    implements JoinProbeFactory {
        private List<Type> types;
        private List<Integer> probeOutputChannels;
        private List<Integer> probeJoinChannels;
        private final OptionalInt probeHashChannel;

        public SimpleJoinProbeFactory(List<Type> types, List<Integer> probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.types = types;
            this.probeOutputChannels = probeOutputChannels;
            this.probeJoinChannels = probeJoinChannels;
            this.probeHashChannel = probeHashChannel;
        }

        @Override
        public JoinProbe createJoinProbe(Page page) {
            return new SimpleJoinProbe(this.types, this.probeOutputChannels, page, this.probeJoinChannels, this.probeHashChannel);
        }
    }
}

