/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.PipelineStatus;
import com.facebook.presto.operator.TaskContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class PipelineContext {
    private final TaskContext taskContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final int pipelineId;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final List<DriverContext> drivers = new CopyOnWriteArrayList<DriverContext>();
    private final AtomicInteger completedDrivers = new AtomicInteger();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final AtomicLong systemMemoryReservation = new AtomicLong();
    private final AtomicLong revocableMemoryReservation = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionEndTime = new AtomicReference();
    private final Distribution queuedTime = new Distribution();
    private final Distribution elapsedTime = new Distribution();
    private final AtomicLong totalScheduledTime = new AtomicLong();
    private final AtomicLong totalCpuTime = new AtomicLong();
    private final AtomicLong totalUserTime = new AtomicLong();
    private final AtomicLong totalBlockedTime = new AtomicLong();
    private final CounterStat rawInputDataSize = new CounterStat();
    private final CounterStat rawInputPositions = new CounterStat();
    private final CounterStat processedInputDataSize = new CounterStat();
    private final CounterStat processedInputPositions = new CounterStat();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final ConcurrentMap<Integer, OperatorStats> operatorSummaries = new ConcurrentHashMap<Integer, OperatorStats>();

    public PipelineContext(int pipelineId, TaskContext taskContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, boolean inputPipeline, boolean outputPipeline) {
        this.pipelineId = pipelineId;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public TaskId getTaskId() {
        return this.taskContext.getTaskId();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    public DriverContext addDriverContext() {
        return this.addDriverContext(false);
    }

    public DriverContext addDriverContext(boolean partitioned) {
        DriverContext driverContext = new DriverContext(this, this.notificationExecutor, this.yieldExecutor, partitioned);
        this.drivers.add(driverContext);
        return driverContext;
    }

    public Session getSession() {
        return this.taskContext.getSession();
    }

    public void driverFinished(DriverContext driverContext) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        if (!this.drivers.remove(driverContext)) {
            throw new IllegalArgumentException("Unknown driver " + driverContext);
        }
        this.lastExecutionEndTime.set(DateTime.now());
        DriverStats driverStats = driverContext.getDriverStats();
        this.completedDrivers.getAndIncrement();
        this.queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
        this.elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalScheduledTime.getAndAdd(driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalCpuTime.getAndAdd(driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalUserTime.getAndAdd(driverStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalBlockedTime.getAndAdd(driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        List<OperatorStats> operators = driverStats.getOperatorStats();
        for (OperatorStats operator : operators) {
            OperatorStats updated;
            OperatorStats current;
            do {
                updated = (current = (OperatorStats)this.operatorSummaries.get(operator.getOperatorId())) != null ? current.add(operator) : operator;
            } while (!PipelineContext.compareAndSet(this.operatorSummaries, operator.getOperatorId(), current, updated));
        }
        this.rawInputDataSize.update(driverStats.getRawInputDataSize().toBytes());
        this.rawInputPositions.update(driverStats.getRawInputPositions());
        this.processedInputDataSize.update(driverStats.getProcessedInputDataSize().toBytes());
        this.processedInputPositions.update(driverStats.getProcessedInputPositions());
        this.outputDataSize.update(driverStats.getOutputDataSize().toBytes());
        this.outputPositions.update(driverStats.getOutputPositions());
    }

    public void start() {
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.lastExecutionStartTime.set(now);
        this.taskContext.start();
    }

    public void failed(Throwable cause) {
        this.taskContext.failed(cause);
    }

    public boolean isDone() {
        return this.taskContext.isDone();
    }

    public void transferMemoryToTaskContext(long bytes) {
        Preconditions.checkArgument((this.memoryReservation.addAndGet(-bytes) >= 0L ? 1 : 0) != 0, (Object)"Tried to transfer more memory than is reserved");
    }

    public synchronized ListenableFuture<?> reserveMemory(long bytes) {
        ListenableFuture<?> future = this.taskContext.reserveMemory(bytes);
        this.memoryReservation.getAndAdd(bytes);
        return future;
    }

    public synchronized ListenableFuture<?> reserveRevocableMemory(long bytes) {
        ListenableFuture<?> future = this.taskContext.reserveRevocableMemory(bytes);
        this.revocableMemoryReservation.getAndAdd(bytes);
        return future;
    }

    public synchronized ListenableFuture<?> reserveSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        ListenableFuture<?> future = this.taskContext.reserveSystemMemory(bytes);
        this.systemMemoryReservation.getAndAdd(bytes);
        return future;
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        return this.taskContext.reserveSpill(bytes);
    }

    public synchronized boolean tryReserveMemory(long bytes) {
        if (this.taskContext.tryReserveMemory(bytes)) {
            this.memoryReservation.getAndAdd(bytes);
            return true;
        }
        return false;
    }

    public synchronized void freeMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.memoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.taskContext.freeMemory(bytes);
        this.memoryReservation.getAndAdd(-bytes);
    }

    public synchronized void freeRevocableMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.revocableMemoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved");
        this.taskContext.freeRevocableMemory(bytes);
        this.revocableMemoryReservation.getAndAdd(-bytes);
    }

    public synchronized void freeSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.systemMemoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more system memory than is reserved");
        this.taskContext.freeSystemMemory(bytes);
        this.systemMemoryReservation.getAndAdd(-bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.taskContext.freeSpill(bytes);
    }

    public void moreMemoryAvailable() {
        this.drivers.forEach(DriverContext::moreMemoryAvailable);
    }

    public boolean isVerboseStats() {
        return this.taskContext.isVerboseStats();
    }

    public boolean isCpuTimerEnabled() {
        return this.taskContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputPositions());
        }
        return stat;
    }

    public PipelineStatus getPipelineStatus() {
        return this.getPipelineStatus((List<DriverContext>)ImmutableList.copyOf(this.drivers));
    }

    public PipelineStats getPipelineStats() {
        if (this.taskContext.getState().isDone()) {
            DateTime now = DateTime.now();
            this.executionStartTime.compareAndSet(null, now);
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.lastExecutionEndTime.compareAndSet(null, now);
        }
        ImmutableList driverContexts = ImmutableList.copyOf(this.drivers);
        PipelineStatus pipelineStatus = this.getPipelineStatus((List<DriverContext>)driverContexts);
        int totalDriers = this.completedDrivers.get() + driverContexts.size();
        int completedDrivers = this.completedDrivers.get();
        Distribution queuedTime = new Distribution(this.queuedTime);
        Distribution elapsedTime = new Distribution(this.elapsedTime);
        long totalScheduledTime = this.totalScheduledTime.get();
        long totalCpuTime = this.totalCpuTime.get();
        long totalUserTime = this.totalUserTime.get();
        long totalBlockedTime = this.totalBlockedTime.get();
        long rawInputDataSize = this.rawInputDataSize.getTotalCount();
        long rawInputPositions = this.rawInputPositions.getTotalCount();
        long processedInputDataSize = this.processedInputDataSize.getTotalCount();
        long processedInputPositions = this.processedInputPositions.getTotalCount();
        long outputDataSize = this.outputDataSize.getTotalCount();
        long outputPositions = this.outputPositions.getTotalCount();
        ArrayList<DriverStats> drivers = new ArrayList<DriverStats>();
        ArrayListMultimap runningOperators = ArrayListMultimap.create();
        for (Object driverContext : driverContexts) {
            DriverStats driverStats = ((DriverContext)driverContext).getDriverStats();
            drivers.add(driverStats);
            queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
            elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
            totalScheduledTime += driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += driverStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            ImmutableList operators = ImmutableList.copyOf((Iterable)Iterables.transform(((DriverContext)driverContext).getOperatorContexts(), OperatorContext::getOperatorStats));
            for (OperatorStats operator : operators) {
                runningOperators.put((Object)operator.getOperatorId(), (Object)operator);
            }
            rawInputDataSize += driverStats.getRawInputDataSize().toBytes();
            rawInputPositions += driverStats.getRawInputPositions();
            processedInputDataSize += driverStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += driverStats.getProcessedInputPositions();
            outputDataSize += driverStats.getOutputDataSize().toBytes();
            outputPositions += driverStats.getOutputPositions();
        }
        TreeMap<Integer, OperatorStats> operatorSummaries = new TreeMap<Integer, OperatorStats>(this.operatorSummaries);
        for (Map.Entry entry : runningOperators.entries()) {
            OperatorStats current = operatorSummaries.get(entry.getKey());
            current = current == null ? (OperatorStats)entry.getValue() : current.add((OperatorStats)entry.getValue());
            operatorSummaries.put((Integer)entry.getKey(), current);
        }
        Set runningDriverStats = (Set)drivers.stream().filter(driver -> driver.getEndTime() == null && driver.getStartTime() != null).collect(ImmutableSet.toImmutableSet());
        ImmutableSet blockedReasons = (ImmutableSet)runningDriverStats.stream().flatMap(driver -> driver.getBlockedReasons().stream()).collect(ImmutableSet.toImmutableSet());
        boolean fullyBlocked = !runningDriverStats.isEmpty() && runningDriverStats.stream().allMatch(DriverStats::isFullyBlocked);
        return new PipelineStats(this.pipelineId, this.executionStartTime.get(), this.lastExecutionStartTime.get(), this.lastExecutionEndTime.get(), this.inputPipeline, this.outputPipeline, totalDriers, pipelineStatus.getQueuedDrivers(), pipelineStatus.getQueuedPartitionedDrivers(), pipelineStatus.getRunningDrivers(), pipelineStatus.getRunningPartitionedDrivers(), pipelineStatus.getBlockedDrivers(), completedDrivers, DataSize.succinctBytes((long)this.memoryReservation.get()), DataSize.succinctBytes((long)this.revocableMemoryReservation.get()), DataSize.succinctBytes((long)this.systemMemoryReservation.get()), queuedTime.snapshot(), elapsedTime.snapshot(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, (Set<BlockedReason>)blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, (List<OperatorStats>)ImmutableList.copyOf(operatorSummaries.values()), drivers);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitPipelineContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.drivers.stream().map(driver -> driver.accept(visitor, context)).collect(Collectors.toList());
    }

    private static <K, V> boolean compareAndSet(ConcurrentMap<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        return map.replace(key, oldValue, newValue);
    }

    private PipelineStatus getPipelineStatus(List<DriverContext> driverContexts) {
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int queuedPartitionedDrivers = 0;
        int runningPartitionedDrivers = 0;
        for (DriverContext driverContext : driverContexts) {
            if (!driverContext.isExecutionStarted()) {
                ++queuedDrivers;
                if (!driverContext.isPartitioned()) continue;
                ++queuedPartitionedDrivers;
                continue;
            }
            if (driverContext.isFullyBlocked()) {
                ++blockedDrivers;
                continue;
            }
            ++runningDrivers;
            if (!driverContext.isPartitioned()) continue;
            ++runningPartitionedDrivers;
        }
        return new PipelineStatus(queuedDrivers, runningDrivers, blockedDrivers, queuedPartitionedDrivers, runningPartitionedDrivers);
    }
}

