/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinOperatorInfo;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.OperatorInfo;
import java.util.Objects;
import java.util.function.Supplier;

public class JoinStatisticsCounter
implements Supplier<OperatorInfo> {
    public static final int HISTOGRAM_BUCKETS = 8;
    private static final int INDIVIDUAL_BUCKETS = 4;
    private final LookupJoinOperators.JoinType joinType;
    private final long[] logHistogramCounters = new long[16];
    private long lookupSourcePositions = -1L;

    public JoinStatisticsCounter(LookupJoinOperators.JoinType joinType) {
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
    }

    public void updateLookupSourcePositions(long lookupSourcePositionsDelta) {
        if (this.lookupSourcePositions == -1L) {
            this.lookupSourcePositions = 0L;
        }
        this.lookupSourcePositions += lookupSourcePositionsDelta;
    }

    public void recordProbe(int numSourcePositions) {
        int bucket = numSourcePositions <= 4 ? numSourcePositions : (numSourcePositions <= 10 ? 5 : (numSourcePositions <= 100 ? 6 : 7));
        int n = 2 * bucket;
        this.logHistogramCounters[n] = this.logHistogramCounters[n] + 1L;
        int n2 = 2 * bucket + 1;
        this.logHistogramCounters[n2] = this.logHistogramCounters[n2] + (long)numSourcePositions;
    }

    @Override
    public JoinOperatorInfo get() {
        return JoinOperatorInfo.createJoinOperatorInfo(this.joinType, this.logHistogramCounters, this.lookupSourcePositions);
    }
}

