/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupIdOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final int[][] groupingSetInputs;
    private final Block[] nullBlocks;
    private final Block[] groupIdBlocks;
    private Page currentPage = null;
    private int currentGroupingSet = 0;
    private boolean finishing;

    public GroupIdOperator(OperatorContext operatorContext, List<Type> types, int[][] groupingSetInputs, Block[] nullBlocks, Block[] groupIdBlocks) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.groupingSetInputs = Objects.requireNonNull(groupingSetInputs, "groupingSetInputs is null");
        this.nullBlocks = Objects.requireNonNull(nullBlocks, "nullBlocks is null");
        this.groupIdBlocks = Objects.requireNonNull(groupIdBlocks, "groupIdBlocks is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage must be null to add a new page");
        this.currentPage = Objects.requireNonNull(page, "page is null");
    }

    @Override
    public Page getOutput() {
        if (this.currentPage == null) {
            return null;
        }
        return this.generateNextPage();
    }

    private Page generateNextPage() {
        Block[] outputBlocks = new Block[this.types.size()];
        for (int i = 0; i < this.groupingSetInputs[this.currentGroupingSet].length; ++i) {
            outputBlocks[i] = this.groupingSetInputs[this.currentGroupingSet][i] == -1 ? new RunLengthEncodedBlock(this.nullBlocks[i], this.currentPage.getPositionCount()) : this.currentPage.getBlock(this.groupingSetInputs[this.currentGroupingSet][i]);
        }
        outputBlocks[outputBlocks.length - 1] = new RunLengthEncodedBlock(this.groupIdBlocks[this.currentGroupingSet], this.currentPage.getPositionCount());
        this.currentGroupingSet = (this.currentGroupingSet + 1) % this.groupingSetInputs.length;
        Page outputPage = new Page(this.currentPage.getPositionCount(), outputBlocks);
        if (this.currentGroupingSet == 0) {
            this.currentPage = null;
        }
        return outputPage;
    }

    public static class GroupIdOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> outputTypes;
        private final List<Map<Integer, Integer>> groupingSetMappings;
        private boolean closed;

        public GroupIdOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> outputTypes, List<Map<Integer, Integer>> groupingSetMappings) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes));
            this.groupingSetMappings = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSetMappings));
        }

        @Override
        public List<Type> getTypes() {
            return this.outputTypes;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, GroupIdOperator.class.getSimpleName());
            int[][] groupingSetInputs = new int[this.groupingSetMappings.size()][this.outputTypes.size() - 1];
            for (int i = 0; i < this.groupingSetMappings.size(); ++i) {
                Arrays.fill(groupingSetInputs[i], -1);
                for (int outputChannel : this.groupingSetMappings.get(i).keySet()) {
                    groupingSetInputs[i][outputChannel] = this.groupingSetMappings.get(i).get(outputChannel);
                }
            }
            Block[] nullBlocks = new Block[this.outputTypes.size()];
            for (int i = 0; i < this.outputTypes.size(); ++i) {
                nullBlocks[i] = this.outputTypes.get(i).createBlockBuilder(new BlockBuilderStatus(), 1).appendNull().build();
            }
            Block[] groupIdBlocks = new Block[this.groupingSetMappings.size()];
            for (int i = 0; i < this.groupingSetMappings.size(); ++i) {
                BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), 1);
                BigintType.BIGINT.writeLong(builder, (long)i);
                groupIdBlocks[i] = builder.build();
            }
            return new GroupIdOperator(operatorContext, this.outputTypes, groupingSetInputs, nullBlocks, groupIdBlocks);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new GroupIdOperatorFactory(this.operatorId, this.planNodeId, this.outputTypes, this.groupingSetMappings);
        }
    }
}

