/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class FilterAndProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final LocalMemoryContext outputMemoryContext;
    private final PageProcessor processor;
    private PageProcessorOutput currentOutput = PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
    private boolean finishing;

    public FilterAndProjectOperator(OperatorContext operatorContext, Iterable<? extends Type> types, PageProcessor processor) {
        this.processor = Objects.requireNonNull(processor, "processor is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputMemoryContext = operatorContext.getSystemMemoryContext().newLocalMemoryContext();
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && !this.currentOutput.hasNext();
        if (finished) {
            this.currentOutput = PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
            this.outputMemoryContext.setBytes(0L);
        }
        return finished;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.currentOutput.hasNext();
    }

    @Override
    public final void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.currentOutput.hasNext() ? 1 : 0) != 0, (Object)"Page buffer is full");
        this.currentOutput = this.processor.process(this.operatorContext.getSession().toConnectorSession(), this.operatorContext.getDriverContext().getYieldSignal(), page);
        this.outputMemoryContext.setBytes(this.currentOutput.getRetainedSizeInBytes());
    }

    @Override
    public final Page getOutput() {
        if (!this.currentOutput.hasNext()) {
            return null;
        }
        return ((Optional)this.currentOutput.next()).orElse(null);
    }

    public static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<PageProcessor> processor;
        private final List<Type> types;
        private boolean closed;

        public FilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, Supplier<PageProcessor> processor, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.processor = Objects.requireNonNull(processor, "processor is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, FilterAndProjectOperator.class.getSimpleName());
            return new FilterAndProjectOperator(operatorContext, this.types, this.processor.get());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new FilterAndProjectOperatorFactory(this.operatorId, this.planNodeId, this.processor, this.types);
        }
    }
}

