/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.ForNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.metadata.RemoteNodeState;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeState;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public final class DiscoveryNodeManager
implements InternalNodeManager {
    private static final Logger log = Logger.get(DiscoveryNodeManager.class);
    private static final Duration MAX_AGE = new Duration(5.0, TimeUnit.SECONDS);
    private static final Splitter CONNECTOR_ID_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final ServiceSelector serviceSelector;
    private final NodeInfo nodeInfo;
    private final FailureDetector failureDetector;
    private final NodeVersion expectedNodeVersion;
    private final ConcurrentHashMap<String, RemoteNodeState> nodeStates = new ConcurrentHashMap();
    private final HttpClient httpClient;
    private final ScheduledExecutorService nodeStateUpdateExecutor;
    private final boolean httpsRequired;
    @GuardedBy(value="this")
    private SetMultimap<ConnectorId, Node> activeNodesByConnectorId;
    @GuardedBy(value="this")
    private AllNodes allNodes;
    @GuardedBy(value="this")
    private long lastUpdateTimestamp;
    private final PrestoNode currentNode;
    @GuardedBy(value="this")
    private Set<Node> coordinators;

    @Inject
    public DiscoveryNodeManager(@ServiceType(value="presto") ServiceSelector serviceSelector, NodeInfo nodeInfo, FailureDetector failureDetector, NodeVersion expectedNodeVersion, @ForNodeManager HttpClient httpClient, InternalCommunicationConfig internalCommunicationConfig) {
        this.serviceSelector = Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        this.expectedNodeVersion = Objects.requireNonNull(expectedNodeVersion, "expectedNodeVersion is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeStateUpdateExecutor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"node-state-poller-%s"));
        this.httpsRequired = internalCommunicationConfig.isHttpsRequired();
        this.currentNode = this.refreshNodesInternal();
    }

    @PostConstruct
    public void startPollingNodeStates() {
        if (this.getCoordinators().contains(this.currentNode)) {
            this.nodeStateUpdateExecutor.scheduleWithFixedDelay(() -> {
                ImmutableSet.Builder nodeSetBuilder = ImmutableSet.builder();
                AllNodes allNodes = this.getAllNodes();
                ImmutableSet aliveNodes = nodeSetBuilder.addAll(allNodes.getActiveNodes()).addAll(allNodes.getShuttingDownNodes()).build();
                ImmutableSet aliveNodeIds = (ImmutableSet)aliveNodes.stream().map(Node::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
                ImmutableSet deadNodes = Sets.difference((Set)this.nodeStates.keySet(), (Set)aliveNodeIds).immutableCopy();
                ((ConcurrentHashMap.KeySetView)this.nodeStates.keySet()).removeAll((Collection)deadNodes);
                for (Node node : aliveNodes) {
                    this.nodeStates.putIfAbsent(node.getNodeIdentifier(), new RemoteNodeState(this.httpClient, HttpUriBuilder.uriBuilderFrom((URI)node.getHttpUri()).appendPath("/v1/info/state").build()));
                }
                this.nodeStates.values().forEach(RemoteNodeState::asyncRefresh);
            }, 1L, 5L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void stop() {
        this.nodeStateUpdateExecutor.shutdownNow();
    }

    @Override
    public void refreshNodes() {
        this.refreshNodesInternal();
    }

    private synchronized PrestoNode refreshNodesInternal() {
        this.lastUpdateTimestamp = System.nanoTime();
        Set services = (Set)this.serviceSelector.selectAllServices().stream().filter(service -> !this.failureDetector.getFailed().contains(service)).collect(ImmutableSet.toImmutableSet());
        PrestoNode currentNode = null;
        ImmutableSet.Builder activeNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder inactiveNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder shuttingDownNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder coordinatorsBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder byConnectorIdBuilder = ImmutableSetMultimap.builder();
        block5: for (ServiceDescriptor service2 : services) {
            URI uri = this.getHttpUri(service2);
            NodeVersion nodeVersion = DiscoveryNodeManager.getNodeVersion(service2);
            boolean coordinator = DiscoveryNodeManager.isCoordinator(service2);
            if (uri == null || nodeVersion == null) continue;
            PrestoNode node = new PrestoNode(service2.getNodeId(), uri, nodeVersion, coordinator);
            NodeState nodeState = this.getNodeState(node);
            if (node.getNodeIdentifier().equals(this.nodeInfo.getNodeId())) {
                currentNode = node;
                Preconditions.checkState((boolean)currentNode.getNodeVersion().equals((Object)this.expectedNodeVersion), (String)"INVARIANT: current node version (%s) should be equal to %s", (Object)currentNode.getNodeVersion(), (Object)this.expectedNodeVersion);
            }
            switch (nodeState) {
                case ACTIVE: {
                    String connectorIds;
                    activeNodesBuilder.add((Object)node);
                    if (coordinator) {
                        coordinatorsBuilder.add((Object)node);
                    }
                    if ((connectorIds = (String)service2.getProperties().get("connectorIds")) != null) {
                        connectorIds = connectorIds.toLowerCase(Locale.ENGLISH);
                        for (String connectorId : CONNECTOR_ID_SPLITTER.split((CharSequence)connectorIds)) {
                            byConnectorIdBuilder.put((Object)new ConnectorId(connectorId), (Object)node);
                        }
                    }
                    byConnectorIdBuilder.put((Object)new ConnectorId("system"), (Object)node);
                    continue block5;
                }
                case INACTIVE: {
                    inactiveNodesBuilder.add((Object)node);
                    continue block5;
                }
                case SHUTTING_DOWN: {
                    shuttingDownNodesBuilder.add((Object)node);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown node state " + nodeState);
        }
        if (this.allNodes != null) {
            Sets.SetView missingNodes = Sets.difference(this.allNodes.getActiveNodes(), (Set)Sets.union((Set)activeNodesBuilder.build(), (Set)shuttingDownNodesBuilder.build()));
            for (Node missingNode : missingNodes) {
                log.info("Previously active node is missing: %s (last seen at %s)", new Object[]{missingNode.getNodeIdentifier(), missingNode.getHostAndPort()});
            }
        }
        this.allNodes = new AllNodes((Set<Node>)activeNodesBuilder.build(), (Set<Node>)inactiveNodesBuilder.build(), (Set<Node>)shuttingDownNodesBuilder.build());
        this.activeNodesByConnectorId = byConnectorIdBuilder.build();
        this.coordinators = coordinatorsBuilder.build();
        Preconditions.checkState((currentNode != null ? 1 : 0) != 0, (Object)"INVARIANT: current node not returned from service selector");
        return currentNode;
    }

    private synchronized void refreshIfNecessary() {
        if (Duration.nanosSince((long)this.lastUpdateTimestamp).compareTo(MAX_AGE) > 0) {
            this.refreshNodesInternal();
        }
    }

    private NodeState getNodeState(PrestoNode node) {
        if (this.expectedNodeVersion.equals((Object)node.getNodeVersion())) {
            if (this.isNodeShuttingDown(node.getNodeIdentifier())) {
                return NodeState.SHUTTING_DOWN;
            }
            return NodeState.ACTIVE;
        }
        return NodeState.INACTIVE;
    }

    private boolean isNodeShuttingDown(String nodeId) {
        Optional remoteNodeState = this.nodeStates.containsKey(nodeId) ? this.nodeStates.get(nodeId).getNodeState() : Optional.empty();
        return remoteNodeState.isPresent() && ((NodeState)remoteNodeState.get()).equals((Object)NodeState.SHUTTING_DOWN);
    }

    @Override
    public synchronized AllNodes getAllNodes() {
        this.refreshIfNecessary();
        return this.allNodes;
    }

    @Managed
    public int getActiveNodeCount() {
        return this.getAllNodes().getActiveNodes().size();
    }

    @Managed
    public int getInactiveNodeCount() {
        return this.getAllNodes().getInactiveNodes().size();
    }

    @Managed
    public int getShuttingDownNodeCount() {
        return this.getAllNodes().getShuttingDownNodes().size();
    }

    @Override
    public Set<Node> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return this.getAllNodes().getActiveNodes();
            }
            case INACTIVE: {
                return this.getAllNodes().getInactiveNodes();
            }
            case SHUTTING_DOWN: {
                return this.getAllNodes().getShuttingDownNodes();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + state);
    }

    @Override
    public synchronized Set<Node> getActiveConnectorNodes(ConnectorId connectorId) {
        this.refreshIfNecessary();
        return this.activeNodesByConnectorId.get((Object)connectorId);
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public synchronized Set<Node> getCoordinators() {
        this.refreshIfNecessary();
        return this.coordinators;
    }

    private URI getHttpUri(ServiceDescriptor descriptor) {
        String url = (String)descriptor.getProperties().get(this.httpsRequired ? "https" : "http");
        if (url != null) {
            try {
                return new URI(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static NodeVersion getNodeVersion(ServiceDescriptor descriptor) {
        String nodeVersion = (String)descriptor.getProperties().get("node_version");
        return nodeVersion == null ? null : new NodeVersion(nodeVersion);
    }

    private static boolean isCoordinator(ServiceDescriptor service) {
        return Boolean.parseBoolean((String)service.getProperties().get("coordinator"));
    }
}

