/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.AggregatedMemoryContext;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SynchronizedAggregatedMemoryContext
extends AbstractAggregatedMemoryContext
implements AutoCloseable {
    private final AbstractAggregatedMemoryContext delegate;
    private final Closer closer = Closer.create();

    public static SynchronizedAggregatedMemoryContext synchronizedMemoryContext(AbstractAggregatedMemoryContext delegate) {
        return new SynchronizedAggregatedMemoryContext(delegate);
    }

    private SynchronizedAggregatedMemoryContext(AggregatedMemoryContext delegate, boolean ownDelegate) {
        this(delegate);
        if (ownDelegate) {
            this.closer.register(delegate::close);
        }
    }

    private SynchronizedAggregatedMemoryContext(AbstractAggregatedMemoryContext delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    protected synchronized void updateBytes(long bytes) {
        this.delegate.updateBytes(bytes);
    }

    @Override
    public AggregatedMemoryContext newAggregatedMemoryContext() {
        throw new UnsupportedOperationException("Use newSynchronizedAggregatedMemoryContext() instead");
    }

    public SynchronizedAggregatedMemoryContext newSynchronizedAggregatedMemoryContext() {
        return new SynchronizedAggregatedMemoryContext(super.newAggregatedMemoryContext(), true);
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

