/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ScheduleResult {
    private final Set<RemoteTask> newTasks;
    private final ListenableFuture<?> blocked;
    private final Optional<BlockedReason> blockedReason;
    private final boolean finished;
    private final int splitsScheduled;

    public ScheduleResult(boolean finished, Iterable<? extends RemoteTask> newTasks, int splitsScheduled) {
        this(finished, newTasks, Futures.immediateFuture(null), Optional.empty(), splitsScheduled);
    }

    public ScheduleResult(boolean finished, Iterable<? extends RemoteTask> newTasks, ListenableFuture<?> blocked, BlockedReason blockedReason, int splitsScheduled) {
        this(finished, newTasks, blocked, Optional.of(Objects.requireNonNull(blockedReason, "blockedReason is null")), splitsScheduled);
    }

    private ScheduleResult(boolean finished, Iterable<? extends RemoteTask> newTasks, ListenableFuture<?> blocked, Optional<BlockedReason> blockedReason, int splitsScheduled) {
        this.finished = finished;
        this.newTasks = ImmutableSet.copyOf(Objects.requireNonNull(newTasks, "newTasks is null"));
        this.blocked = Objects.requireNonNull(blocked, "blocked is null");
        this.blockedReason = Objects.requireNonNull(blockedReason, "blockedReason is null");
        this.splitsScheduled = splitsScheduled;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<RemoteTask> getNewTasks() {
        return this.newTasks;
    }

    public ListenableFuture<?> getBlocked() {
        return this.blocked;
    }

    public int getSplitsScheduled() {
        return this.splitsScheduled;
    }

    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("finished", this.finished).add("newTasks", this.newTasks.size()).add("blocked", this.blocked.isDone()).add("splitsScheduled", this.splitsScheduled).add("blockedReason", this.blockedReason).toString();
    }

    public static enum BlockedReason {
        SPLIT_QUEUES_FULL,
        WAITING_FOR_SOURCE;

    }
}

