/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroup;
import com.facebook.presto.execution.resourceGroups.LegacyResourceGroupConfigurationManagerFactory;
import com.facebook.presto.execution.resourceGroups.ResourceGroupConfigurationManagerContextInstance;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.server.ResourceGroupStateInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public final class InternalResourceGroupManager
implements ResourceGroupManager {
    private static final Logger log = Logger.get(InternalResourceGroupManager.class);
    private static final File RESOURCE_GROUPS_CONFIGURATION = new File("etc/resource-groups.properties");
    private static final String CONFIGURATION_MANAGER_PROPERTY_NAME = "resource-groups.configuration-manager";
    private final ScheduledExecutorService refreshExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"ResourceGroupManager"));
    private final List<InternalResourceGroup.RootInternalResourceGroup> rootGroups = new CopyOnWriteArrayList<InternalResourceGroup.RootInternalResourceGroup>();
    private final ConcurrentMap<ResourceGroupId, InternalResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, InternalResourceGroup>();
    private final AtomicReference<ResourceGroupConfigurationManager> configurationManager = new AtomicReference();
    private final ResourceGroupConfigurationManagerContext configurationManagerContext;
    private final MBeanExporter exporter;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastCpuQuotaGenerationNanos = new AtomicLong(System.nanoTime());
    private final Map<String, ResourceGroupConfigurationManagerFactory> configurationManagerFactories = new ConcurrentHashMap<String, ResourceGroupConfigurationManagerFactory>();

    @Inject
    public InternalResourceGroupManager(LegacyResourceGroupConfigurationManagerFactory builtinFactory, ClusterMemoryPoolManager memoryPoolManager, NodeInfo nodeInfo, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        this.configurationManagerContext = new ResourceGroupConfigurationManagerContextInstance(memoryPoolManager, nodeInfo.getEnvironment());
        Objects.requireNonNull(builtinFactory, "builtinFactory is null");
        this.addConfigurationManagerFactory(builtinFactory);
    }

    @Override
    public ResourceGroupInfo getResourceGroupInfo(ResourceGroupId id) {
        Preconditions.checkArgument((boolean)this.groups.containsKey(id), (String)"Group %s does not exist", (Object)id);
        return ((InternalResourceGroup)this.groups.get(id)).getInfo();
    }

    @Override
    public ResourceGroupStateInfo getResourceGroupStateInfo(ResourceGroupId id) {
        if (!this.groups.containsKey(id)) {
            throw new NoSuchElementException();
        }
        return ((InternalResourceGroup)this.groups.get(id)).getStateInfo();
    }

    @Override
    public void submit(Statement statement, QueryExecution queryExecution, Executor executor) {
        ResourceGroupId group;
        Preconditions.checkState((this.configurationManager.get() != null ? 1 : 0) != 0, (Object)"configurationManager not set");
        try {
            group = this.selectGroup(queryExecution);
        }
        catch (PrestoException e) {
            queryExecution.fail(e);
            return;
        }
        this.createGroupIfNecessary(group, queryExecution, executor);
        ((InternalResourceGroup)this.groups.get(group)).run(queryExecution);
    }

    @Override
    public void addConfigurationManagerFactory(ResourceGroupConfigurationManagerFactory factory) {
        if (this.configurationManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
    }

    @Override
    public void loadConfigurationManager() throws Exception {
        if (RESOURCE_GROUPS_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(InternalResourceGroupManager.loadProperties(RESOURCE_GROUPS_CONFIGURATION));
            String configurationManagerName = (String)properties.remove(CONFIGURATION_MANAGER_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationManagerName) ? 1 : 0) != 0, (String)"Resource groups configuration %s does not contain %s", (Object)RESOURCE_GROUPS_CONFIGURATION.getAbsoluteFile(), (Object)CONFIGURATION_MANAGER_PROPERTY_NAME);
            this.setConfigurationManager(configurationManagerName, properties);
        } else {
            this.setConfigurationManager("legacy", (Map<String, String>)ImmutableMap.of());
        }
    }

    @VisibleForTesting
    public void setConfigurationManager(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading resource group configuration manager --");
        ResourceGroupConfigurationManagerFactory configurationManagerFactory = this.configurationManagerFactories.get(name);
        Preconditions.checkState((configurationManagerFactory != null ? 1 : 0) != 0, (String)"Resource group configuration manager %s is not registered", (Object)name);
        ResourceGroupConfigurationManager configurationManager = configurationManagerFactory.create((Map)ImmutableMap.copyOf(properties), this.configurationManagerContext);
        Preconditions.checkState((boolean)this.configurationManager.compareAndSet(null, configurationManager), (Object)"configurationManager already set");
        log.info("-- Loaded resource group configuration manager %s --", new Object[]{name});
    }

    @VisibleForTesting
    public ResourceGroupConfigurationManager getConfigurationManager() {
        return this.configurationManager.get();
    }

    private static Map<String, String> loadProperties(File file) throws Exception {
        Objects.requireNonNull(file, "file is null");
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        return Maps.fromProperties((Properties)properties);
    }

    @PreDestroy
    public void destroy() {
        this.refreshExecutor.shutdownNow();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.refreshExecutor.scheduleWithFixedDelay(this::refreshAndStartQueries, 1L, 1L, TimeUnit.MILLISECONDS);
        }
    }

    private void refreshAndStartQueries() {
        long nanoTime = System.nanoTime();
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime - this.lastCpuQuotaGenerationNanos.get());
        if (elapsedSeconds > 0L) {
            this.lastCpuQuotaGenerationNanos.addAndGet(elapsedSeconds * 1000000000L);
        } else if (elapsedSeconds < 0L) {
            this.lastCpuQuotaGenerationNanos.set(nanoTime);
        }
        for (InternalResourceGroup.RootInternalResourceGroup group : this.rootGroups) {
            try {
                if (elapsedSeconds > 0L) {
                    group.generateCpuQuota(elapsedSeconds);
                }
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while generation cpu quota for %s", new Object[]{group});
            }
            try {
                group.processQueuedQueries();
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while processing queued queries for %s", new Object[]{group});
            }
        }
    }

    private synchronized void createGroupIfNecessary(ResourceGroupId id, QueryExecution queryExecution, Executor executor) {
        Session session = queryExecution.getSession();
        SelectionContext context = new SelectionContext(session.getIdentity().getPrincipal().isPresent(), session.getUser(), session.getSource(), SystemSessionProperties.getQueryPriority(session), this.determineQueryType(queryExecution));
        if (!this.groups.containsKey(id)) {
            InternalResourceGroup group;
            if (id.getParent().isPresent()) {
                this.createGroupIfNecessary((ResourceGroupId)id.getParent().get(), queryExecution, executor);
                InternalResourceGroup parent = (InternalResourceGroup)this.groups.get(id.getParent().get());
                Objects.requireNonNull(parent, "parent is null");
                group = parent.getOrCreateSubGroup(id.getLastSegment());
            } else {
                InternalResourceGroup.RootInternalResourceGroup root;
                group = root = new InternalResourceGroup.RootInternalResourceGroup((String)id.getSegments().get(0), this::exportGroup, executor);
                this.rootGroups.add(root);
            }
            this.configurationManager.get().configure((ResourceGroup)group, context);
            Preconditions.checkState((this.groups.put(id, group) == null ? 1 : 0) != 0, (Object)"Unexpected existing resource group");
        }
    }

    private void exportGroup(InternalResourceGroup group, Boolean export) {
        String objectName = ObjectNames.builder(InternalResourceGroup.class, (String)group.getId().toString()).build();
        try {
            if (export.booleanValue()) {
                this.exporter.export(objectName, (Object)group);
            } else {
                this.exporter.unexport(objectName);
            }
        }
        catch (JmxException e) {
            log.error((Throwable)e, "Error %s resource group %s", new Object[]{export != false ? "exporting" : "unexporting", group.getId()});
        }
    }

    private ResourceGroupId selectGroup(QueryExecution queryExecution) {
        Session session = queryExecution.getSession();
        SelectionContext context = new SelectionContext(session.getIdentity().getPrincipal().isPresent(), session.getUser(), session.getSource(), SystemSessionProperties.getQueryPriority(session), this.determineQueryType(queryExecution));
        for (ResourceGroupSelector selector : this.configurationManager.get().getSelectors()) {
            Optional group = selector.match(context);
            if (!group.isPresent()) continue;
            return (ResourceGroupId)group.get();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Query did not match any selection rule");
    }

    private Optional<String> determineQueryType(QueryExecution queryExecution) {
        return queryExecution.getQueryType().map(Enum::toString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueriesQueuedOnInternal() {
        int queriesQueuedInternal = 0;
        Iterator<InternalResourceGroup.RootInternalResourceGroup> iterator = this.rootGroups.iterator();
        while (iterator.hasNext()) {
            InternalResourceGroup.RootInternalResourceGroup rootGroup;
            InternalResourceGroup.RootInternalResourceGroup rootInternalResourceGroup = rootGroup = iterator.next();
            synchronized (rootInternalResourceGroup) {
                queriesQueuedInternal += InternalResourceGroupManager.getQueriesQueuedOnInternal(rootGroup);
            }
        }
        return queriesQueuedInternal;
    }

    private static int getQueriesQueuedOnInternal(InternalResourceGroup resourceGroup) {
        if (resourceGroup.subGroups().isEmpty()) {
            return Math.min(resourceGroup.getQueuedQueries(), resourceGroup.getSoftConcurrencyLimit() - resourceGroup.getRunningQueries());
        }
        int queriesQueuedInternal = 0;
        for (InternalResourceGroup subGroup : resourceGroup.subGroups()) {
            queriesQueuedInternal += InternalResourceGroupManager.getQueriesQueuedOnInternal(subGroup);
        }
        return queriesQueuedInternal;
    }
}

