/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.executor.MultilevelSplitQueue;
import com.facebook.presto.execution.executor.Priority;
import com.facebook.presto.execution.executor.TaskHandle;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;

public class LegacyTaskHandle
extends TaskHandle {
    public LegacyTaskHandle(TaskId taskId, MultilevelSplitQueue splitQueue, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency) {
        super(taskId, splitQueue, utilizationSupplier, initialSplitConcurrency, splitConcurrencyAdjustFrequency);
    }

    @Override
    public synchronized Priority addScheduledNanos(long durationNanos) {
        Priority newPriority;
        this.concurrencyController.update(durationNanos, this.utilizationSupplier.getAsDouble(), this.runningLeafSplits.size());
        this.scheduledNanos += durationNanos;
        Priority oldPriority = (Priority)this.priority.get();
        if (oldPriority.getLevel() < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1 && this.scheduledNanos >= TimeUnit.SECONDS.toNanos(MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[oldPriority.getLevel() + 1])) {
            int newLevel = MultilevelSplitQueue.computeLevel(this.scheduledNanos);
            newPriority = new Priority(newLevel, this.scheduledNanos);
        } else {
            newPriority = new Priority(oldPriority.getLevel(), this.scheduledNanos);
        }
        this.priority.set(newPriority);
        return newPriority;
    }

    @Override
    public synchronized Priority resetLevelPriority() {
        return (Priority)this.priority.get();
    }
}

