/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryQueue;
import com.facebook.presto.execution.QueryQueueDefinition;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.QueryQueueRule;
import com.facebook.presto.execution.QueuedExecution;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public class SqlQueryQueueManager
implements QueryQueueManager {
    private final ConcurrentMap<QueueKey, QueryQueue> queryQueues = new ConcurrentHashMap<QueueKey, QueryQueue>();
    private final List<QueryQueueRule> rules;
    private final MBeanExporter mbeanExporter;

    @Inject
    public SqlQueryQueueManager(List<QueryQueueRule> rules, MBeanExporter mbeanExporter) {
        this.mbeanExporter = Objects.requireNonNull(mbeanExporter, "mbeanExporter is null");
        this.rules = ImmutableList.copyOf(rules);
    }

    @Override
    public void submit(Statement statement, QueryExecution queryExecution, Executor executor) {
        List<QueryQueue> queues;
        try {
            queues = this.selectQueues(queryExecution.getSession(), executor);
        }
        catch (PrestoException e) {
            queryExecution.fail(e);
            return;
        }
        for (QueryQueue queue : queues) {
            if (queue.reserve(queryExecution)) continue;
            queryExecution.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, "Too many queued queries"));
            return;
        }
        queues.get(0).enqueue(QueuedExecution.createQueuedExecution(queryExecution, queues.subList(1, queues.size()), executor));
    }

    private List<QueryQueue> selectQueues(Session session, Executor executor) {
        for (QueryQueueRule rule : this.rules) {
            Optional<List<QueryQueueDefinition>> queues = rule.match(session.toSessionRepresentation());
            if (!queues.isPresent()) continue;
            return this.getOrCreateQueues(session, executor, queues.get());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Query did not match any queuing rule");
    }

    private List<QueryQueue> getOrCreateQueues(Session session, Executor executor, List<QueryQueueDefinition> definitions) {
        ImmutableList.Builder queues = ImmutableList.builder();
        for (QueryQueueDefinition definition : definitions) {
            QueryQueue queue;
            String expandedName;
            QueueKey key = new QueueKey(definition, expandedName = definition.getExpandedTemplate(session));
            if (!this.queryQueues.containsKey(key) && this.queryQueues.putIfAbsent(key, queue = new QueryQueue(executor, definition.getMaxQueued(), definition.getMaxConcurrent())) == null) {
                String objectName = ObjectNames.builder(QueryQueue.class, (String)definition.getTemplate()).withProperty("expansion", expandedName).build();
                this.mbeanExporter.export(objectName, (Object)queue);
            }
            queues.add(this.queryQueues.get(key));
        }
        return queues.build();
    }

    @PreDestroy
    public void destroy() {
        for (QueueKey key : this.queryQueues.keySet()) {
            String objectName = ObjectNames.builder(QueryQueue.class, (String)key.getQueue().getTemplate()).withProperty("expansion", key.getName()).build();
            this.mbeanExporter.unexport(objectName);
        }
    }

    private static class QueueKey {
        private final QueryQueueDefinition queue;
        private final String name;

        private QueueKey(QueryQueueDefinition queue, String name) {
            this.queue = Objects.requireNonNull(queue, "queue is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public QueryQueueDefinition getQueue() {
            return this.queue;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            QueueKey queueKey = (QueueKey)other;
            return Objects.equals(this.name, queueKey.name) && Objects.equals(this.queue.getTemplate(), queueKey.queue.getTemplate());
        }

        public int hashCode() {
            return Objects.hash(this.queue.getTemplate(), this.name);
        }
    }
}

