/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryQueue;
import com.facebook.presto.execution.SqlQueryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.SetThreadName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class QueuedExecution {
    private final QueryExecution queryExecution;
    private final List<QueryQueue> nextQueues;
    private final ListenableFuture<?> listenableFuture;
    private final Executor executor;

    public static QueuedExecution createQueuedExecution(QueryExecution queryExecution, List<QueryQueue> nextQueues, Executor executor) {
        SettableFuture settableFuture = SettableFuture.create();
        SqlQueryManager.addCompletionCallback(queryExecution, () -> settableFuture.set(null));
        return new QueuedExecution(queryExecution, nextQueues, executor, (ListenableFuture<?>)settableFuture);
    }

    private QueuedExecution(QueryExecution queryExecution, List<QueryQueue> nextQueues, Executor executor, ListenableFuture<?> listenableFuture) {
        this.queryExecution = Objects.requireNonNull(queryExecution, "queryExecution is null");
        this.nextQueues = ImmutableList.copyOf((Collection)Objects.requireNonNull(nextQueues, "nextQueues is null"));
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.listenableFuture = Objects.requireNonNull(listenableFuture, "listenableFuture is null");
    }

    public ListenableFuture<?> getCompletionFuture() {
        return this.listenableFuture;
    }

    public void start() {
        if (this.listenableFuture.isDone()) {
            return;
        }
        if (this.nextQueues.isEmpty()) {
            this.executor.execute(() -> {
                try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryExecution.getQueryId()});){
                    this.queryExecution.start();
                }
            });
        } else {
            this.nextQueues.get(0).enqueue(new QueuedExecution(this.queryExecution, this.nextQueues.subList(1, this.nextQueues.size()), this.executor, this.listenableFuture));
        }
    }
}

