/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger log = Logger.get(QueryStateMachine.class);
    private final DateTime createTime = DateTime.now();
    private final long createNanos;
    private final AtomicLong endNanos = new AtomicLong();
    private final QueryId queryId;
    private final String query;
    private final Session session;
    private final URI self;
    private final boolean autoCommit;
    private final TransactionManager transactionManager;
    private final Ticker ticker;
    private final Metadata metadata;
    private final AtomicReference<VersionedMemoryPoolId> memoryPool = new AtomicReference<VersionedMemoryPoolId>(new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L));
    private final AtomicLong peakMemory = new AtomicLong();
    private final AtomicLong currentMemory = new AtomicLong();
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> endTime = new AtomicReference();
    private final AtomicReference<Duration> queuedTime = new AtomicReference();
    private final AtomicReference<Duration> analysisTime = new AtomicReference();
    private final AtomicReference<Duration> distributedPlanningTime = new AtomicReference();
    private final AtomicReference<Long> finishingStartNanos = new AtomicReference();
    private final AtomicReference<Duration> finishingTime = new AtomicReference();
    private final AtomicReference<Long> totalPlanningStartNanos = new AtomicReference();
    private final AtomicReference<Duration> totalPlanningTime = new AtomicReference();
    private final StateMachine<QueryState> queryState;
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<List<String>> outputFieldNames = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Optional<Output>> output = new AtomicReference(Optional.empty());
    private final StateMachine<Optional<QueryInfo>> finalQueryInfo;
    private final AtomicReference<ResourceGroupId> resourceGroup = new AtomicReference();

    private QueryStateMachine(QueryId queryId, String query, Session session, URI self, boolean autoCommit, TransactionManager transactionManager, Executor executor, Ticker ticker, Metadata metadata) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.autoCommit = autoCommit;
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.ticker = ticker;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.createNanos = this.tickerNanos();
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.QUEUED, QueryState.TERMINAL_QUERY_STATES);
        this.finalQueryInfo = new StateMachine("finalQueryInfo-" + queryId, executor, Optional.empty());
    }

    public static QueryStateMachine begin(QueryId queryId, String query, Session session, URI self, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Metadata metadata) {
        return QueryStateMachine.beginWithTicker(queryId, query, session, self, transactionControl, transactionManager, accessControl, executor, Ticker.systemTicker(), metadata);
    }

    static QueryStateMachine beginWithTicker(QueryId queryId, String query, Session session, URI self, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Ticker ticker, Metadata metadata) {
        Session querySession;
        boolean autoCommit;
        session.getTransactionId().ifPresent(transactionControl ? transactionManager::trySetActive : transactionManager::checkAndSetActive);
        boolean bl = autoCommit = !session.getTransactionId().isPresent() && !transactionControl;
        if (autoCommit) {
            TransactionId transactionId = transactionManager.beginTransaction(true);
            querySession = session.beginTransactionId(transactionId, transactionManager, accessControl);
        } else {
            querySession = session;
        }
        QueryStateMachine queryStateMachine = new QueryStateMachine(queryId, query, querySession, self, autoCommit, transactionManager, executor, ticker, metadata);
        queryStateMachine.addStateChangeListener(newState -> {
            log.debug("Query %s is %s", new Object[]{queryId, newState});
            if (newState.isDone()) {
                session.getTransactionId().ifPresent(transactionManager::trySetInactive);
            }
        });
        return queryStateMachine;
    }

    public static QueryStateMachine failed(QueryId queryId, String query, Session session, URI self, TransactionManager transactionManager, Executor executor, Metadata metadata, Throwable throwable) {
        return QueryStateMachine.failedWithTicker(queryId, query, session, self, transactionManager, executor, Ticker.systemTicker(), metadata, throwable);
    }

    static QueryStateMachine failedWithTicker(QueryId queryId, String query, Session session, URI self, TransactionManager transactionManager, Executor executor, Ticker ticker, Metadata metadata, Throwable throwable) {
        QueryStateMachine queryStateMachine = new QueryStateMachine(queryId, query, session, self, false, transactionManager, executor, ticker, metadata);
        queryStateMachine.transitionToFailed(throwable);
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public long getPeakMemoryInBytes() {
        return this.peakMemory.get();
    }

    public void updateMemoryUsage(long deltaMemoryInBytes) {
        long currentMemoryValue = this.currentMemory.addAndGet(deltaMemoryInBytes);
        if (currentMemoryValue > this.peakMemory.get()) {
            this.peakMemory.updateAndGet(x -> currentMemoryValue > x ? currentMemoryValue : x);
        }
    }

    public void setResourceGroup(ResourceGroupId group) {
        Objects.requireNonNull(group, "group is null");
        this.resourceGroup.compareAndSet(null, group);
    }

    public Optional<ResourceGroupId> getResourceGroup() {
        return Optional.ofNullable(this.resourceGroup.get());
    }

    public QueryInfo getQueryInfoWithoutDetails() {
        return this.getQueryInfo(Optional.empty());
    }

    public QueryInfo getQueryInfo(Optional<StageInfo> rootStage) {
        ExecutionFailureInfo failureCause;
        QueryState state = this.queryState.get();
        Duration elapsedTime = this.endNanos.get() != 0L ? new Duration((double)(this.endNanos.get() - this.createNanos), TimeUnit.NANOSECONDS) : this.nanosSince(this.createNanos);
        FailureInfo failureInfo = null;
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            failureInfo = failureCause.toFailureInfo();
            errorCode = failureCause.getErrorCode();
        }
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long cumulativeMemory = 0L;
        long totalMemoryReservation = 0L;
        long peakMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        boolean fullyBlocked = rootStage.isPresent();
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        ImmutableList.Builder operatorStatsSummary = ImmutableList.builder();
        boolean completeInfo = true;
        for (StageInfo stageInfo : StageInfo.getAllStages(rootStage)) {
            PlanFragment plan;
            StageStats stageStats = stageInfo.getStageStats();
            totalTasks += stageStats.getTotalTasks();
            runningTasks += stageStats.getRunningTasks();
            completedTasks += stageStats.getCompletedTasks();
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            blockedDrivers += stageStats.getBlockedDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeMemory = (long)((double)cumulativeMemory + stageStats.getCumulativeMemory());
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            peakMemoryReservation = this.getPeakMemoryInBytes();
            totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += stageStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (!stageInfo.getState().isDone()) {
                fullyBlocked &= stageStats.isFullyBlocked();
                blockedReasons.addAll(stageStats.getBlockedReasons());
            }
            if ((plan = stageInfo.getPlan()) != null) {
                if (plan.getPartitionedSourceNodes().stream().anyMatch(TableScanNode.class::isInstance)) {
                    rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                    rawInputPositions += stageStats.getRawInputPositions();
                    processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                    processedInputPositions += stageStats.getProcessedInputPositions();
                }
            }
            completeInfo = completeInfo && stageInfo.isCompleteInfo();
            operatorStatsSummary.addAll(stageInfo.getStageStats().getOperatorSummaries());
        }
        if (rootStage.isPresent()) {
            StageStats outputStageStats = rootStage.get().getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        boolean isScheduled = QueryStateMachine.isScheduled(rootStage);
        QueryStats queryStats = new QueryStats(this.createTime, this.executionStartTime.get(), this.lastHeartbeat.get(), this.endTime.get(), elapsedTime.convertToMostSuccinctTimeUnit(), this.queuedTime.get(), this.analysisTime.get(), this.distributedPlanningTime.get(), this.totalPlanningTime.get(), this.finishingTime.get(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeMemory, DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)peakMemoryReservation), isScheduled, new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, (List<OperatorStats>)operatorStatsSummary.build());
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.memoryPool.get().getId(), isScheduled, this.self, this.outputFieldNames.get(), this.query, queryStats, this.setSessionProperties, this.resetSessionProperties, this.addedPreparedStatements, this.deallocatedPreparedStatements, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureInfo, errorCode, this.inputs.get(), this.output.get(), completeInfo, this.getResourceGroup().map(ResourceGroupId::toString));
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return this.memoryPool.get();
    }

    public void setMemoryPool(VersionedMemoryPoolId memoryPool) {
        this.memoryPool.set(Objects.requireNonNull(memoryPool, "memoryPool is null"));
    }

    public void setOutputFieldNames(List<String> outputFieldNames) {
        Objects.requireNonNull(outputFieldNames, "outputFieldNames is null");
        this.outputFieldNames.set((List<String>)ImmutableList.copyOf(outputFieldNames));
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public void setOutput(Optional<Output> output) {
        Objects.requireNonNull(output, "output is null");
        this.output.set(output);
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public void addPreparedStatement(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.addedPreparedStatements.put(key, value);
    }

    public void removePreparedStatement(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!this.session.getPreparedStatements().containsKey(key)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + key);
        }
        this.deallocatedPreparedStatements.add(key);
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToPlanning() {
        this.queuedTime.compareAndSet(null, this.nanosSince(this.createNanos).convertToMostSuccinctTimeUnit());
        this.totalPlanningStartNanos.compareAndSet(null, this.tickerNanos());
        return this.queryState.compareAndSet(QueryState.QUEUED, QueryState.PLANNING);
    }

    public boolean transitionToStarting() {
        this.queuedTime.compareAndSet(null, this.nanosSince(this.createNanos).convertToMostSuccinctTimeUnit());
        this.totalPlanningStartNanos.compareAndSet(null, this.tickerNanos());
        this.totalPlanningTime.compareAndSet(null, this.nanosSince(this.totalPlanningStartNanos.get()));
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState == QueryState.QUEUED || currentState == QueryState.PLANNING);
    }

    public boolean transitionToRunning() {
        Duration durationSinceCreation = this.nanosSince(this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningStartNanos.compareAndSet(null, this.tickerNanos());
        this.totalPlanningTime.compareAndSet(null, this.nanosSince(this.totalPlanningStartNanos.get()));
        this.executionStartTime.compareAndSet(null, DateTime.now());
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState != QueryState.RUNNING && currentState != QueryState.FINISHING && !currentState.isDone());
    }

    public boolean transitionToFinishing() {
        Duration durationSinceCreation = this.nanosSince(this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningStartNanos.compareAndSet(null, this.tickerNanos());
        this.totalPlanningTime.compareAndSet(null, this.nanosSince(this.totalPlanningStartNanos.get()));
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.finishingStartNanos.compareAndSet(null, this.tickerNanos());
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        if (this.autoCommit) {
            ListenableFuture<?> commitFuture = this.transactionManager.asyncCommit(this.session.getTransactionId().get());
            Futures.addCallback(commitFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    QueryStateMachine.this.transitionToFinished();
                }

                public void onFailure(Throwable throwable) {
                    QueryStateMachine.this.transitionToFailed(throwable);
                }
            });
        } else {
            this.transitionToFinished();
        }
        return true;
    }

    private boolean transitionToFinished() {
        this.cleanupQueryQuietly();
        this.recordDoneStats();
        return this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        this.cleanupQueryQuietly();
        this.recordDoneStats();
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            log.debug(throwable, "Query %s failed", new Object[]{this.queryId});
            this.session.getTransactionId().ifPresent(this.autoCommit ? this.transactionManager::asyncAbort : this.transactionManager::fail);
        } else {
            log.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
        }
        return failed;
    }

    public boolean transitionToCanceled() {
        this.cleanupQueryQuietly();
        this.recordDoneStats();
        this.failureCause.compareAndSet(null, Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled")));
        boolean canceled = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (canceled) {
            this.session.getTransactionId().ifPresent(this.autoCommit ? this.transactionManager::asyncAbort : this.transactionManager::fail);
        }
        return canceled;
    }

    private void cleanupQueryQuietly() {
        try {
            this.metadata.cleanupQuery(this.session);
        }
        catch (Throwable t) {
            log.error("Error cleaning up query: %s", new Object[]{t});
        }
    }

    private void recordDoneStats() {
        Duration durationSinceCreation = this.nanosSince(this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningStartNanos.compareAndSet(null, this.tickerNanos());
        this.totalPlanningTime.compareAndSet(null, this.nanosSince(this.totalPlanningStartNanos.get()));
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.finishingStartNanos.compareAndSet(null, this.tickerNanos());
        this.finishingTime.compareAndSet(null, this.nanosSince(this.finishingStartNanos.get()));
        this.endTime.compareAndSet(null, now);
        this.endNanos.compareAndSet(0L, this.tickerNanos());
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public void addQueryInfoStateChangeListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalQueryInfo -> {
            if (finalQueryInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((QueryInfo)finalQueryInfo.get());
            }
        };
        this.finalQueryInfo.addStateChangeListener(fireOnceStateChangeListener);
        fireOnceStateChangeListener.stateChanged(this.finalQueryInfo.get());
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public void recordAnalysisTime(long analysisStart) {
        this.analysisTime.compareAndSet(null, this.nanosSince(analysisStart).convertToMostSuccinctTimeUnit());
    }

    public void recordDistributedPlanningTime(long distributedPlanningStart) {
        this.distributedPlanningTime.compareAndSet(null, this.nanosSince(distributedPlanningStart).convertToMostSuccinctTimeUnit());
    }

    private static boolean isScheduled(Optional<StageInfo> rootStage) {
        if (!rootStage.isPresent()) {
            return false;
        }
        return StageInfo.getAllStages(rootStage).stream().map(StageInfo::getState).allMatch(state -> state == StageState.RUNNING || state.isDone());
    }

    public Optional<QueryInfo> getFinalQueryInfo() {
        return this.finalQueryInfo.get();
    }

    public QueryInfo updateQueryInfo(Optional<StageInfo> stageInfo) {
        QueryInfo queryInfo = this.getQueryInfo(stageInfo);
        if (queryInfo.isFinalQueryInfo()) {
            this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(queryInfo));
        }
        return queryInfo;
    }

    public void pruneQueryInfo() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (!finalInfo.isPresent() || !finalInfo.get().getOutputStage().isPresent()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        StageInfo outputStage = queryInfo.getOutputStage().get();
        StageInfo prunedOutputStage = new StageInfo(outputStage.getStageId(), outputStage.getState(), outputStage.getSelf(), null, outputStage.getTypes(), outputStage.getStageStats(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), outputStage.getFailureCause());
        QueryInfo prunedQueryInfo = new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), this.getMemoryPool().getId(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), this.pruneQueryStats(queryInfo.getQueryStats()), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), Optional.of(prunedOutputStage), queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getInputs(), queryInfo.getOutput(), queryInfo.isCompleteInfo(), queryInfo.getResourceGroupName());
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    private QueryStats pruneQueryStats(QueryStats queryStats) {
        return new QueryStats(queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getLastHeartbeat(), queryStats.getEndTime(), queryStats.getElapsedTime(), queryStats.getQueuedTime(), queryStats.getAnalysisTime(), queryStats.getDistributedPlanningTime(), queryStats.getTotalPlanningTime(), queryStats.getFinishingTime(), queryStats.getTotalTasks(), queryStats.getRunningTasks(), queryStats.getCompletedTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getBlockedDrivers(), queryStats.getCompletedDrivers(), queryStats.getCumulativeMemory(), queryStats.getTotalMemoryReservation(), queryStats.getPeakMemoryReservation(), queryStats.isScheduled(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getTotalUserTime(), queryStats.getTotalBlockedTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getProcessedInputDataSize(), queryStats.getProcessedInputPositions(), queryStats.getOutputDataSize(), queryStats.getOutputPositions(), (List<OperatorStats>)ImmutableList.of());
    }

    private long tickerNanos() {
        return this.ticker.read();
    }

    private Duration nanosSince(long start) {
        return Duration.succinctNanos((long)(this.tickerNanos() - start));
    }
}

