/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.statistics.Estimate;
import java.util.Objects;
import java.util.function.Function;

public class PlanNodeCost {
    public static final PlanNodeCost UNKNOWN_COST = PlanNodeCost.builder().build();
    private final Estimate outputRowCount;
    private final Estimate outputSizeInBytes;

    private PlanNodeCost(Estimate outputRowCount, Estimate outputSizeInBytes) {
        this.outputRowCount = Objects.requireNonNull(outputRowCount, "outputRowCount can not be null");
        this.outputSizeInBytes = Objects.requireNonNull(outputSizeInBytes, "outputSizeInBytes can not be null");
    }

    public Estimate getOutputRowCount() {
        return this.outputRowCount;
    }

    public Estimate getOutputSizeInBytes() {
        return this.outputSizeInBytes;
    }

    public PlanNodeCost mapOutputRowCount(Function<Double, Double> mappingFunction) {
        return PlanNodeCost.buildFrom(this).setOutputRowCount(this.outputRowCount.map(mappingFunction)).build();
    }

    public PlanNodeCost mapOutputSizeInBytes(Function<Double, Double> mappingFunction) {
        return PlanNodeCost.buildFrom(this).setOutputSizeInBytes(this.outputRowCount.map(mappingFunction)).build();
    }

    public String toString() {
        return "PlanNodeCost{outputRowCount=" + this.outputRowCount + ", outputSizeInBytes=" + this.outputSizeInBytes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeCost that = (PlanNodeCost)o;
        return Objects.equals(this.outputRowCount, that.outputRowCount) && Objects.equals(this.outputSizeInBytes, that.outputSizeInBytes);
    }

    public int hashCode() {
        return Objects.hash(this.outputRowCount, this.outputSizeInBytes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(PlanNodeCost other) {
        return PlanNodeCost.builder().setOutputRowCount(other.getOutputRowCount()).setOutputSizeInBytes(other.getOutputSizeInBytes());
    }

    public static final class Builder {
        private Estimate outputRowCount = Estimate.unknownValue();
        private Estimate outputSizeInBytes = Estimate.unknownValue();

        public Builder setOutputRowCount(Estimate outputRowCount) {
            this.outputRowCount = outputRowCount;
            return this;
        }

        public Builder setOutputSizeInBytes(Estimate outputSizeInBytes) {
            this.outputSizeInBytes = outputSizeInBytes;
            return this;
        }

        public PlanNodeCost build() {
            return new PlanNodeCost(this.outputRowCount, this.outputSizeInBytes);
        }
    }
}

