/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.Session;
import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTransactionHandle;
import com.facebook.presto.metadata.InternalTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.PrivilegeInfo;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InformationSchemaPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Metadata metadata;
    private final AccessControl accessControl;

    public InformationSchemaPageSourceProvider(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        InternalTable table = this.getInternalTable(transactionHandle, session, split, columns);
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (ColumnHandle column : columns) {
            String columnName = ((InformationSchemaColumnHandle)column).getColumnName();
            int columnIndex = table.getColumnIndex(columnName);
            channels.add(columnIndex);
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        for (Page page : table.getPages()) {
            Block[] blocks = new Block[channels.size()];
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = page.getBlock(((Integer)channels.get(index)).intValue());
            }
            pages.add((Object)new Page(page.getPositionCount(), blocks));
        }
        return new FixedPageSource((Iterable)pages.build());
    }

    private InternalTable getInternalTable(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, ConnectorSplit connectorSplit, List<ColumnHandle> columns) {
        InformationSchemaTransactionHandle transaction = (InformationSchemaTransactionHandle)transactionHandle;
        InformationSchemaSplit split = (InformationSchemaSplit)connectorSplit;
        Objects.requireNonNull(columns, "columns is null");
        InformationSchemaTableHandle handle = split.getTableHandle();
        Map<String, NullableValue> filters = split.getFilters();
        Session session = Session.builder(this.metadata.getSessionPropertyManager()).setTransactionId(transaction.getTransactionId()).setQueryId(new QueryId(connectorSession.getQueryId())).setIdentity(connectorSession.getIdentity()).setSource("information_schema").setCatalog("").setSchema("").setTimeZoneKey(connectorSession.getTimeZoneKey()).setLocale(connectorSession.getLocale()).setStartTime(connectorSession.getStartTime()).build();
        return this.getInformationSchemaTable(session, handle.getCatalogName(), handle.getSchemaTableName(), filters);
    }

    public InternalTable getInformationSchemaTable(Session session, String catalog, SchemaTableName table, Map<String, NullableValue> filters) {
        if (table.equals((Object)InformationSchemaMetadata.TABLE_COLUMNS)) {
            return this.buildColumns(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLES)) {
            return this.buildTables(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_VIEWS)) {
            return this.buildViews(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_SCHEMATA)) {
            return this.buildSchemata(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS)) {
            return this.buildPartitions(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES)) {
            return this.buildTablePrivileges(session, catalog, filters);
        }
        throw new IllegalArgumentException(String.format("table does not exist: %s", table));
    }

    private InternalTable buildColumns(Session session, String catalogName, Map<String, NullableValue> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_COLUMNS));
        QualifiedTablePrefix prefix = InformationSchemaPageSourceProvider.extractQualifiedTablePrefix(catalogName, filters);
        for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : MetadataListing.listTableColumns(session, this.metadata, this.accessControl, prefix).entrySet()) {
            SchemaTableName tableName = entry.getKey();
            int ordinalPosition = 1;
            for (ColumnMetadata column : entry.getValue()) {
                if (column.isHidden()) continue;
                table.add(catalogName, tableName.getSchemaName(), tableName.getTableName(), column.getName(), ordinalPosition, null, "YES", column.getType().getDisplayName(), column.getComment(), column.getExtraInfo());
                ++ordinalPosition;
            }
        }
        return table.build();
    }

    private InternalTable buildTables(Session session, String catalogName, Map<String, NullableValue> filters) {
        QualifiedTablePrefix prefix = InformationSchemaPageSourceProvider.extractQualifiedTablePrefix(catalogName, filters);
        Set<SchemaTableName> tables = MetadataListing.listTables(session, this.metadata, this.accessControl, prefix);
        Set<SchemaTableName> views = MetadataListing.listViews(session, this.metadata, this.accessControl, prefix);
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLES));
        for (SchemaTableName name : Sets.union(tables, views)) {
            String type = views.contains(name) ? "VIEW" : "BASE TABLE";
            table.add(catalogName, name.getSchemaName(), name.getTableName(), type);
        }
        return table.build();
    }

    private InternalTable buildTablePrivileges(Session session, String catalogName, Map<String, NullableValue> filters) {
        QualifiedTablePrefix prefix = InformationSchemaPageSourceProvider.extractQualifiedTablePrefix(catalogName, filters);
        ImmutableList grants = ImmutableList.copyOf(MetadataListing.listTablePrivileges(session, this.metadata, this.accessControl, prefix));
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES));
        for (GrantInfo grant : grants) {
            for (PrivilegeInfo privilegeInfo : grant.getPrivilegeInfo()) {
                table.add(grant.getGrantor().orElse(null), grant.getIdentity().getUser(), catalogName, grant.getSchemaTableName().getSchemaName(), grant.getSchemaTableName().getTableName(), privilegeInfo.getPrivilege().name(), privilegeInfo.isGrantOption(), grant.getWithHierarchy().orElse(null));
            }
        }
        return table.build();
    }

    private InternalTable buildViews(Session session, String catalogName, Map<String, NullableValue> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_VIEWS));
        for (Map.Entry<QualifiedObjectName, ViewDefinition> entry : this.getViews(session, catalogName, filters).entrySet()) {
            table.add(entry.getKey().getCatalogName(), entry.getKey().getSchemaName(), entry.getKey().getObjectName(), entry.getValue().getOriginalSql());
        }
        return table.build();
    }

    private Map<QualifiedObjectName, ViewDefinition> getViews(Session session, String catalogName, Map<String, NullableValue> filters) {
        return this.metadata.getViews(session, InformationSchemaPageSourceProvider.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildSchemata(Session session, String catalogName) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_SCHEMATA));
        for (String schema : MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalogName)) {
            table.add(catalogName, schema);
        }
        return table.build();
    }

    private InternalTable buildPartitions(Session session, String catalogName, Map<String, NullableValue> filters) {
        QualifiedObjectName tableName = InformationSchemaPageSourceProvider.extractQualifiedTableName(catalogName, filters);
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS));
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, tableName);
        if (!tableHandle.isPresent()) {
            throw new TableNotFoundException(tableName.asSchemaTableName());
        }
        List<TableLayoutResult> layouts = this.metadata.getLayouts(session, tableHandle.get(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
        if (layouts.size() == 1) {
            ImmutableBiMap columnHandles = ImmutableBiMap.copyOf(this.metadata.getColumnHandles(session, tableHandle.get())).inverse();
            HashMap<ColumnHandle, MethodHandle> methodHandles = new HashMap<ColumnHandle, MethodHandle>();
            for (ColumnHandle columnHandle : columnHandles.keySet()) {
                try {
                    ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle.get(), columnHandle);
                    Signature operator = this.metadata.getFunctionRegistry().getCoercion(columnMetadata.getType(), (Type)VarcharType.createUnboundedVarcharType());
                    MethodHandle methodHandle = this.metadata.getFunctionRegistry().getScalarFunctionImplementation(operator).getMethodHandle();
                    methodHandles.put(columnHandle, methodHandle);
                }
                catch (OperatorNotFoundException operatorNotFoundException) {}
            }
            TableLayout layout = ((TableLayoutResult)Iterables.getOnlyElement(layouts)).getLayout();
            layout.getDiscretePredicates().ifPresent(arg_0 -> InformationSchemaPageSourceProvider.lambda$buildPartitions$0((Map)columnHandles, methodHandles, table, catalogName, tableName, arg_0));
        }
        return table.build();
    }

    private static QualifiedObjectName extractQualifiedTableName(String catalogName, Map<String, NullableValue> filters) {
        Optional<String> schemaName = InformationSchemaPageSourceProvider.getFilterColumn(filters, "table_schema");
        Preconditions.checkArgument((boolean)schemaName.isPresent(), (String)"filter is required for column: %s.%s", (Object)InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, (Object)"table_schema");
        Optional<String> tableName = InformationSchemaPageSourceProvider.getFilterColumn(filters, "table_name");
        Preconditions.checkArgument((boolean)tableName.isPresent(), (String)"filter is required for column: %s.%s", (Object)InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, (Object)"table_name");
        return new QualifiedObjectName(catalogName, schemaName.get(), tableName.get());
    }

    private static QualifiedTablePrefix extractQualifiedTablePrefix(String catalogName, Map<String, NullableValue> filters) {
        Optional<String> schemaName = InformationSchemaPageSourceProvider.getFilterColumn(filters, "table_schema");
        Optional<String> tableName = InformationSchemaPageSourceProvider.getFilterColumn(filters, "table_name");
        if (!schemaName.isPresent()) {
            return new QualifiedTablePrefix(catalogName, Optional.empty(), Optional.empty());
        }
        return new QualifiedTablePrefix(catalogName, schemaName, tableName);
    }

    private static Optional<String> getFilterColumn(Map<String, NullableValue> filters, String columnName) {
        NullableValue value = filters.get(columnName);
        if (value == null || value.getValue() == null) {
            return Optional.empty();
        }
        if (Varchars.isVarcharType((Type)value.getType())) {
            return Optional.of(((Slice)value.getValue()).toStringUtf8().toLowerCase(Locale.ENGLISH));
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$buildPartitions$0(Map columnHandles, Map methodHandles, InternalTable.Builder table, String catalogName, QualifiedObjectName tableName, DiscretePredicates predicates) {
        int partitionNumber = 1;
        for (TupleDomain domain : predicates.getPredicates()) {
            for (Map.Entry entry : ((Map)TupleDomain.extractFixedValues((TupleDomain)domain).get()).entrySet()) {
                ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
                String columnName = (String)columnHandles.get(columnHandle);
                String value = null;
                if (((NullableValue)entry.getValue()).getValue() != null) {
                    if (methodHandles.containsKey(columnHandle)) {
                        try {
                            value = ((Slice)((MethodHandle)methodHandles.get(columnHandle)).invokeWithArguments(((NullableValue)entry.getValue()).getValue())).toStringUtf8();
                        }
                        catch (Throwable throwable) {
                            throw Throwables.propagate((Throwable)throwable);
                        }
                    } else {
                        value = "<UNREPRESENTABLE VALUE>";
                    }
                }
                table.add(catalogName, tableName.getSchemaName(), tableName.getObjectName(), partitionNumber, columnName, value);
            }
            ++partitionNumber;
        }
    }
}

