/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FinalizerService {
    private static final Logger log = Logger.get(FinalizerService.class);
    private final Set<FinalizerReference> finalizers = Sets.newConcurrentHashSet();
    private final ReferenceQueue<Object> finalizerQueue = new ReferenceQueue();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(Threads.daemonThreadsNamed((String)"FinalizerService"));
    @GuardedBy(value="this")
    private Future<?> finalizerTask;

    @PostConstruct
    public synchronized void start() {
        if (this.finalizerTask != null) {
            return;
        }
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("Finalizer service has been destroyed");
        }
        this.finalizerTask = this.executor.submit(this::processFinalizerQueue);
    }

    @PreDestroy
    public synchronized void destroy() {
        if (this.finalizerTask != null) {
            this.finalizerTask.cancel(true);
            this.finalizerTask = null;
        }
        this.executor.shutdownNow();
    }

    public void addFinalizer(Object referent, Runnable cleanup) {
        Objects.requireNonNull(referent, "referent is null");
        Objects.requireNonNull(cleanup, "cleanup is null");
        this.finalizers.add(new FinalizerReference(referent, this.finalizerQueue, cleanup));
    }

    private void processFinalizerQueue() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                FinalizerReference finalizer = (FinalizerReference)this.finalizerQueue.remove();
                this.finalizers.remove(finalizer);
                finalizer.cleanup();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                log.error(e, "Finalizer cleanup failed");
            }
        }
    }

    private static class FinalizerReference
    extends PhantomReference<Object> {
        private final Runnable cleanup;
        private final AtomicBoolean executed = new AtomicBoolean();

        public FinalizerReference(Object referent, ReferenceQueue<Object> queue, Runnable cleanup) {
            super(Objects.requireNonNull(referent, "referent is null"), Objects.requireNonNull(queue, "queue is null"));
            this.cleanup = Objects.requireNonNull(cleanup, "cleanup is null");
        }

        public void cleanup() {
            if (this.executed.compareAndSet(false, true)) {
                this.cleanup.run();
            }
        }
    }
}

