/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.AbstractLongType;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.RoundingMode;

public final class DoubleOperators {
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_PLUS_ONE_AS_DOUBLE = 9.223372036854776E18;
    private static final double MIN_INTEGER_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INTEGER_PLUS_ONE_AS_DOUBLE = 2.147483648E9;
    private static final double MIN_SHORT_AS_DOUBLE = -32768.0;
    private static final double MAX_SHORT_PLUS_ONE_AS_DOUBLE = 32768.0;
    private static final double MIN_BYTE_AS_DOUBLE = -128.0;
    private static final double MAX_BYTE_PLUS_ONE_AS_DOUBLE = 128.0;

    private DoubleOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="double")
    public static double add(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="double")
    public static double subtract(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="double")
    public static double multiply(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="double")
    public static double divide(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="double")
    public static double modulus(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="double")
    public static double negate(@SqlType(value="double") double value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="double") double value, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="double") double value) {
        return value != 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="double") double value) {
        try {
            return Math.toIntExact((long)MathFunctions.round(value));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="double") double value) {
        try {
            return Shorts.checkedCast((long)((long)MathFunctions.round(value)));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="double") double value) {
        try {
            return SignedBytes.checkedCast((long)((long)MathFunctions.round(value)));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="double") double value) {
        return (long)MathFunctions.round(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="double") double value) {
        return Float.floatToRawIntBits((float)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="double") double value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="double") double value) {
        return AbstractLongType.hash((long)Double.doubleToLongBits(value));
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="real")
    public static strictfp long saturatedFloorCastToFloat(@SqlType(value="double") double value) {
        float result;
        float minFloat = -3.4028235E38f;
        if (value <= (double)minFloat) {
            result = minFloat;
        } else if (value >= 3.4028234663852886E38) {
            result = Float.MAX_VALUE;
        } else {
            result = (float)value;
            if ((double)result > value) {
                result = Math.nextDown(result);
            }
            Preconditions.checkState(((double)result <= value ? 1 : 0) != 0);
        }
        return Float.floatToRawIntBits(result);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="integer")
    public static long saturatedFloorCastToInteger(@SqlType(value="double") double value) {
        return DoubleOperators.saturatedFloorCastToLong(value, Integer.MIN_VALUE, -2.147483648E9, Integer.MAX_VALUE, 2.147483648E9);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="double") double value) {
        return DoubleOperators.saturatedFloorCastToLong(value, -32768L, -32768.0, 32767L, 32768.0);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="double") double value) {
        return DoubleOperators.saturatedFloorCastToLong(value, -128L, -128.0, 127L, 128.0);
    }

    private static long saturatedFloorCastToLong(double value, long minValue, double minValueAsDouble, long maxValue, double maxValuePlusOneAsDouble) {
        if (value <= minValueAsDouble) {
            return minValue;
        }
        if (value + 1.0 >= maxValuePlusOneAsDouble) {
            return maxValue;
        }
        return DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="double") double left, @IsNull boolean leftNull, @SqlType(value="double") double right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return DoubleOperators.notEqual(left, right);
    }
}

