/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.TaskSource;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.connector.system.GlobalSystemConnectorFactory;
import com.facebook.presto.connector.system.NodeSystemTable;
import com.facebook.presto.connector.system.SchemaPropertiesSystemTable;
import com.facebook.presto.connector.system.TablePropertiesSystemTable;
import com.facebook.presto.connector.system.TransactionsSystemTable;
import com.facebook.presto.cost.CoefficientBasedCostCalculator;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DeallocateTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PrepareTask;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PageSourceOperator;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.project.InterpretedPageProjection;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.JoinProbeCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.testing.TreeAssertions;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.management.MBeanServer;
import org.intellij.lang.annotations.Language;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.testing.TestingMBeanServer;

public class LocalQueryRunner
implements QueryRunner {
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final InMemoryNodeManager nodeManager;
    private final TypeRegistry typeRegistry;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final MetadataManager metadata;
    private final CostCalculator costCalculator;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private final SpillerFactory spillerFactory;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final ConnectorManager connectorManager;
    private final ImmutableMap<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;
    private final boolean alwaysRevokeMemory;
    private final NodeSpillConfig nodeSpillConfig;
    private boolean printPlan;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LocalQueryRunner(Session defaultSession) {
        this(defaultSession, new FeaturesConfig().setOptimizeMixedDistinctAggregations(true).setIterativeOptimizerEnabled(true), false, false);
    }

    public LocalQueryRunner(Session defaultSession, boolean alwaysRevokeMemory) {
        this(defaultSession, new FeaturesConfig().setOptimizeMixedDistinctAggregations(true).setIterativeOptimizerEnabled(true), false, alwaysRevokeMemory);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig) {
        this(defaultSession, featuresConfig, false, false);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory) {
        this(defaultSession, featuresConfig, new NodeSpillConfig(), withInitialTransaction, alwaysRevokeMemory);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.alwaysRevokeMemory = alwaysRevokeMemory;
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager();
        this.typeRegistry = new TypeRegistry();
        this.pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory());
        this.pageIndexerFactory = new GroupByHashPageIndexerFactory(new JoinCompiler());
        this.indexManager = new IndexManager();
        NodeScheduler nodeScheduler = new NodeScheduler(new LegacyNetworkTopology(), this.nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(this.finalizerService));
        this.pageSinkManager = new PageSinkManager();
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = TransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, catalogManager, this.notificationExecutor);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler);
        this.splitManager = new SplitManager(new QueryManagerConfig());
        this.blockEncodingSerde = new BlockEncodingManager((TypeManager)this.typeRegistry, new BlockEncodingFactory[0]);
        this.metadata = new MetadataManager(featuresConfig, this.typeRegistry, this.blockEncodingSerde, new SessionPropertyManager(new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig)), new SchemaPropertyManager(), new TablePropertyManager(), this.transactionManager);
        this.costCalculator = new CoefficientBasedCostCalculator(this.metadata);
        this.accessControl = new TestingAccessControlManager(this.transactionManager);
        this.pageSourceManager = new PageSourceManager();
        this.pageFunctionCompiler = new PageFunctionCompiler((Metadata)this.metadata, 0);
        this.expressionCompiler = new ExpressionCompiler(this.metadata, this.pageFunctionCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(this.metadata);
        this.connectorManager = new ConnectorManager(this.metadata, catalogManager, this.accessControl, this.splitManager, this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, new HandleResolver(), this.nodeManager, new NodeInfo("test"), this.typeRegistry, this.pageSorter, this.pageIndexerFactory, this.transactionManager);
        GlobalSystemConnectorFactory globalSystemConnectorFactory = new GlobalSystemConnectorFactory((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(this.metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(this.transactionManager, this.metadata), (Object)new TablePropertiesSystemTable(this.transactionManager, this.metadata), (Object)new TransactionsSystemTable(this.typeRegistry, this.transactionManager)), (Set<Procedure>)ImmutableSet.of());
        this.connectorManager.addConnectorFactory(globalSystemConnectorFactory);
        this.connectorManager.createConnection("system", "system", (Map<String, String>)ImmutableMap.of());
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog("testing_catalog"));
        this.defaultSession = new Session(defaultSession.getQueryId(), withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(false)) : defaultSession.getTransactionId(), defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getStartTime(), defaultSession.getSystemProperties(), defaultSession.getConnectorProperties(), defaultSession.getUnprocessedCatalogProperties(), this.metadata.getSessionPropertyManager(), defaultSession.getPreparedStatements());
        this.dataDefinitionTask = ImmutableMap.builder().put(CreateTable.class, (Object)new CreateTableTask()).put(CreateView.class, (Object)new CreateViewTask((JsonCodec<ViewDefinition>)JsonCodec.jsonCodec(ViewDefinition.class), this.sqlParser, new FeaturesConfig())).put(DropTable.class, (Object)new DropTableTask()).put(DropView.class, (Object)new DropViewTask()).put(RenameColumn.class, (Object)new RenameColumnTask()).put(RenameTable.class, (Object)new RenameTableTask()).put(ResetSession.class, (Object)new ResetSessionTask()).put(SetSession.class, (Object)new SetSessionTask()).put(Prepare.class, (Object)new PrepareTask(this.sqlParser)).put(Deallocate.class, (Object)new DeallocateTask()).put(StartTransaction.class, (Object)new StartTransactionTask()).put(Commit.class, (Object)new CommitTask()).put(Rollback.class, (Object)new RollbackTask()).build();
        SpillerStats spillerStats = new SpillerStats();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.blockEncodingSerde, spillerStats, featuresConfig);
        this.spillerFactory = new GenericSpillerFactory(this.singleStreamSpillerFactory);
    }

    public static LocalQueryRunner queryRunnerWithInitialTransaction(Session defaultSession) {
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Already in transaction!");
        return new LocalQueryRunner(defaultSession, new FeaturesConfig(), new NodeSpillConfig(), true, false);
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.connectorManager.stop();
        this.finalizerService.destroy();
        this.singleStreamSpillerFactory.destroy();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public TypeRegistry getTypeManager() {
        return this.typeRegistry;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ExecutorService getExecutor() {
        return this.notificationExecutor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.yieldExecutor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeConnector(new ConnectorId(catalogName));
        this.connectorManager.addConnectorFactory(connectorFactory);
        this.connectorManager.createConnection(catalogName, connectorFactory.getName(), properties);
    }

    @Override
    public void installPlugin(Plugin plugin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.inTransaction(session, transactionSession -> this.executeInternal((Session)transactionSession, sql));
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.defaultSession, transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.transactionManager, this.accessControl).singleStatement().execute(session, transactionSessionConsumer);
    }

    /*
     * Exception decompiling
     */
    private MaterializedResult executeInternal(Session session, @Language(value="SQL") String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        Plan plan = this.createPlan(session, sql);
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, this.costCalculator, session));
        }
        if (!(subplan = PlanFragmenter.createSubPlans(session, this.metadata, plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.metadata, this.sqlParser, this.costCalculator, Optional.empty(), this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, null, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), new CompilerConfig().setInterpreterEnabled(false), new TaskManagerConfig().setTaskConcurrency(4), this.spillerFactory, this.blockEncodingSerde, new PagesIndex.TestingFactory(), new JoinCompiler(), new LookupJoinOperators(new JoinProbeCompiler()));
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, subplan.getFragment().getRoot(), subplan.getFragment().getPartitioningScheme().getOutputLayout(), plan.getTypes(), outputFactory);
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            TableLayoutHandle layout = tableScan.getLayout().get();
            SplitSource splitSource = this.splitManager.getSplits(session, layout);
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : (List)MoreFutures.getFutureValue(splitSource.getNextBatch(1000))) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver()).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        for (TaskSource source : sources) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(source.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            for (ScheduledSplit scheduledSplit : source.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver()).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSource(new TaskSource(scheduledSplit.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)scheduledSplit), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.close();
        }
        return ImmutableList.copyOf(drivers);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql) {
        return this.createPlan(session, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage) {
        return this.createPlan(session, sql, stage, true);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        Statement statement = SqlQueryManager.unwrapExecuteStatement(this.sqlParser.createStatement(sql), this.sqlParser, session);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (Node)statement);
        return this.createPlan(session, sql, this.getPlanOptimizers(forceSingleNode), stage);
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean forceSingleNode) {
        FeaturesConfig featuresConfig = new FeaturesConfig().setDistributedIndexJoinsEnabled(false).setOptimizeHashGeneration(true);
        return new PlanOptimizers(this.metadata, this.sqlParser, featuresConfig, forceSingleNode, new MBeanExporter((MBeanServer)new TestingMBeanServer())).get();
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers) {
        return this.createPlan(session, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, LogicalPlanner.Stage stage) {
        Statement wrapped = this.sqlParser.createStatement(sql);
        Statement statement = SqlQueryManager.unwrapExecuteStatement(wrapped, this.sqlParser, session);
        List parameters = Collections.emptyList();
        if (wrapped instanceof Execute) {
            parameters = ((Execute)wrapped).getParameters();
        }
        SqlQueryManager.validateParameters(statement, parameters);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (Node)statement);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        QueryExplainer queryExplainer = new QueryExplainer(optimizers, (Metadata)this.metadata, (AccessControl)this.accessControl, this.sqlParser, this.costCalculator, (Map<Class<? extends Statement>, DataDefinitionTask<?>>)this.dataDefinitionTask);
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(queryExplainer), parameters);
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, optimizers, idAllocator, this.metadata, this.sqlParser, this.costCalculator);
        Analysis analysis = analyzer.analyze(statement);
        return logicalPlanner.plan(analysis, stage);
    }

    public OperatorFactory createTableScanOperator(Session session, int operatorId, PlanNodeId planNodeId, String tableName, String ... columnNames) {
        Preconditions.checkArgument((boolean)session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkArgument((boolean)session.getSchema().isPresent(), (Object)"schema not set");
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName(session.getCatalog().get(), session.getSchema().get(), tableName);
        TableHandle tableHandle = this.metadata.getTableHandle(session, qualifiedTableName).orElse(null);
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object)qualifiedTableName);
        Map<String, ColumnHandle> allColumnHandles = this.metadata.getColumnHandles(session, tableHandle);
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnTypesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = allColumnHandles.get(columnName);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table %s does not have a column %s", (Object)tableName, (Object)columnName);
            columnHandlesBuilder.add((Object)columnHandle);
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
            columnTypesBuilder.add((Object)columnMetadata.getType());
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        ImmutableList columnTypes = columnTypesBuilder.build();
        List<TableLayoutResult> layouts = this.metadata.getLayouts(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
        Split split = this.getLocalQuerySplit(session, layouts.get(0).getLayout().getHandle());
        return new OperatorFactory((List)columnTypes, operatorId, planNodeId, session, split, (List)columnHandles){
            final /* synthetic */ List val$columnTypes;
            final /* synthetic */ int val$operatorId;
            final /* synthetic */ PlanNodeId val$planNodeId;
            final /* synthetic */ Session val$session;
            final /* synthetic */ Split val$split;
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnTypes = list;
                this.val$operatorId = n;
                this.val$planNodeId = planNodeId;
                this.val$session = session;
                this.val$split = split;
                this.val$columnHandles = list2;
            }

            @Override
            public List<Type> getTypes() {
                return this.val$columnTypes;
            }

            @Override
            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.val$operatorId, this.val$planNodeId, "BenchmarkSource");
                ConnectorPageSource pageSource = LocalQueryRunner.this.pageSourceManager.createPageSource(this.val$session, this.val$split, this.val$columnHandles);
                return new PageSourceOperator(pageSource, this.val$columnTypes, operatorContext);
            }

            @Override
            public void close() {
            }

            @Override
            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> columnTypes) {
        ImmutableMap.Builder symbolTypes = ImmutableMap.builder();
        ImmutableMap.Builder symbolToInputMapping = ImmutableMap.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int channel = 0; channel < columnTypes.size(); ++channel) {
            Symbol symbol = new Symbol("h" + channel);
            symbolTypes.put((Object)symbol, (Object)columnTypes.get(channel));
            symbolToInputMapping.put((Object)symbol, (Object)channel);
            projections.add((Object)new InterpretedPageProjection((Expression)new SymbolReference(symbol.getName()), (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)columnTypes.get(channel)), (Map<Symbol, Integer>)ImmutableMap.of((Object)symbol, (Object)channel), this.metadata, this.sqlParser, this.defaultSession));
        }
        Optional<Expression> hashExpression = HashGenerationOptimizer.getHashExpression((List<Symbol>)ImmutableList.copyOf((Collection)symbolTypes.build().keySet()));
        Verify.verify((boolean)hashExpression.isPresent());
        projections.add((Object)new InterpretedPageProjection(hashExpression.get(), (Map<Symbol, Type>)symbolTypes.build(), (Map<Symbol, Integer>)symbolToInputMapping.build(), this.metadata, this.sqlParser, this.defaultSession));
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(operatorId, planNodeId, () -> new PageProcessor(Optional.empty(), (List<? extends PageProjection>)projections.build()), (List<Type>)ImmutableList.copyOf((Iterable)Iterables.concat(columnTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))));
    }

    private Split getLocalQuerySplit(Session session, TableLayoutHandle handle) {
        SplitSource splitSource = this.splitManager.getSplits(session, handle);
        ArrayList splits = new ArrayList();
        splits.addAll((Collection)MoreFutures.getFutureValue(splitSource.getNextBatch(1000)));
        while (!splitSource.isFinished()) {
            splits.addAll((Collection)MoreFutures.getFutureValue(splitSource.getNextBatch(1000)));
        }
        Preconditions.checkArgument((splits.size() == 1 ? 1 : 0) != 0, (String)"Expected only one split for a local query, but got %s splits", (int)splits.size());
        return (Split)splits.get(0);
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        ImmutableList.Builder tableScanNodes = ImmutableList.builder();
        LocalQueryRunner.findTableScanNodes(node, (ImmutableList.Builder<TableScanNode>)tableScanNodes);
        return tableScanNodes.build();
    }

    private static void findTableScanNodes(PlanNode node, ImmutableList.Builder<TableScanNode> builder) {
        for (PlanNode source : node.getSources()) {
            LocalQueryRunner.findTableScanNodes(source, builder);
        }
        if (node instanceof TableScanNode) {
            builder.add((Object)((TableScanNode)node));
        }
    }

    private static /* synthetic */ boolean lambda$executeInternal$4(OperatorContext operatorContext) {
        return operatorContext.getOperatorStats().getRevocableMemoryReservation().getValue() > 0.0;
    }

    private static /* synthetic */ Consumer lambda$executeInternal$3(AtomicReference builder, Session session, List types) {
        builder.compareAndSet(null, MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)types));
        return ((MaterializedResult.Builder)builder.get())::page;
    }
}

