/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class SimplePlanRewriter<C>
extends PlanVisitor<PlanNode, RewriteContext<C>> {
    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, null));
    }

    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node, C context) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, context));
    }

    @Override
    protected PlanNode visitPlan(PlanNode node, RewriteContext<C> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C> {
        private final C userContext;
        private final SimplePlanRewriter<C> nodeRewriter;

        private RewriteContext(SimplePlanRewriter<C> nodeRewriter, C userContext) {
            this.nodeRewriter = nodeRewriter;
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public PlanNode defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null);
        }

        public PlanNode defaultRewrite(PlanNode node, C context) {
            List children = (List)node.getSources().stream().map(child -> this.rewrite((PlanNode)child, context)).collect(ImmutableList.toImmutableList());
            return ChildReplacer.replaceChildren(node, children);
        }

        public PlanNode rewrite(PlanNode node, C userContext) {
            PlanNode result = (PlanNode)node.accept(this.nodeRewriter, new RewriteContext<C>(this.nodeRewriter, userContext));
            Verify.verify((result != null ? 1 : 0) != 0, (String)"nodeRewriter returned null for %s", (Object[])new Object[]{node.getClass().getName()});
            return result;
        }

        public PlanNode rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }
}

