/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SymbolMapper {
    private final Map<Symbol, Symbol> mapping;

    public SymbolMapper(Map<Symbol, Symbol> mapping) {
        this.mapping = ImmutableMap.copyOf(Objects.requireNonNull(mapping, "mapping is null"));
    }

    public Symbol map(Symbol symbol) {
        Symbol canonical = symbol;
        while (this.mapping.containsKey(canonical) && !this.mapping.get(canonical).equals(canonical)) {
            canonical = this.mapping.get(canonical);
        }
        return canonical;
    }

    public Expression map(Expression value) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol canonical = SymbolMapper.this.map(Symbol.from((Expression)node));
                return canonical.toSymbolReference();
            }
        }, (Expression)value);
    }

    public AggregationNode map(AggregationNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public AggregationNode map(AggregationNode node, PlanNode source, PlanNodeIdAllocator idAllocator) {
        return this.map(node, source, idAllocator.getNextId());
    }

    private AggregationNode map(AggregationNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            aggregations.put((Object)this.map(symbol), (Object)new AggregationNode.Aggregation((FunctionCall)this.map((Expression)aggregation.getCall()), aggregation.getSignature(), aggregation.getMask().map(this::map)));
        }
        List groupingSets = (List)node.getGroupingSets().stream().map(this::mapAndDistinct).collect(ImmutableList.toImmutableList());
        return new AggregationNode(newNodeId, source, (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), groupingSets, node.getStep(), node.getHashSymbol().map(this::map), node.getGroupIdSymbol().map(this::map));
    }

    public TopNNode map(TopNNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableList.Builder symbols = ImmutableList.builder();
        ImmutableMap.Builder orderings = ImmutableMap.builder();
        HashSet<Symbol> seenCanonicals = new HashSet<Symbol>(node.getOrderBy().size());
        for (Symbol symbol : node.getOrderBy()) {
            Symbol canonical = this.map(symbol);
            if (!seenCanonicals.add(canonical)) continue;
            seenCanonicals.add(canonical);
            symbols.add((Object)canonical);
            orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
        }
        return new TopNNode(newNodeId, source, node.getCount(), (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build(), node.getStep());
    }

    private List<Symbol> mapAndDistinct(List<Symbol> outputs) {
        HashSet<Symbol> added = new HashSet<Symbol>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : outputs) {
            Symbol canonical = this.map(symbol);
            if (!added.add(canonical)) continue;
            builder.add((Object)canonical);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableMap.Builder<Symbol, Symbol> mappings = ImmutableMap.builder();

        public SymbolMapper build() {
            return new SymbolMapper((Map<Symbol, Symbol>)this.mappings.build());
        }

        public void put(Symbol from, Symbol to) {
            this.mappings.put((Object)from, (Object)to);
        }
    }
}

