/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;

public class PushTableWriteThroughUnion
implements Rule<TableWriterNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<TableWriterNode> PATTERN = Patterns.tableWriterNode().matching(tableWriter -> !tableWriter.getPartitioningScheme().isPresent()).with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<TableWriterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isPushTableWriteThroughUnion(session);
    }

    @Override
    public Rule.Result apply(TableWriterNode tableWriterNode, Captures captures, Rule.Context context) {
        UnionNode unionNode = (UnionNode)captures.get(CHILD);
        ImmutableList.Builder rewrittenSources = ImmutableList.builder();
        ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
        for (int i = 0; i < unionNode.getSources().size(); ++i) {
            int index = i;
            ImmutableList.Builder newSymbols = ImmutableList.builder();
            for (Symbol outputSymbol : tableWriterNode.getOutputSymbols()) {
                Symbol newSymbol = context.getSymbolAllocator().newSymbol(outputSymbol);
                newSymbols.add((Object)newSymbol);
                mappings.put((Object)outputSymbol, (Object)newSymbol);
            }
            rewrittenSources.add((Object)new TableWriterNode(context.getIdAllocator().getNextId(), unionNode.getSources().get(index), tableWriterNode.getTarget(), (List)tableWriterNode.getColumns().stream().map(column -> (Symbol)unionNode.getSymbolMapping().get(column).get(index)).collect(ImmutableList.toImmutableList()), tableWriterNode.getColumnNames(), (List<Symbol>)newSymbols.build(), tableWriterNode.getPartitioningScheme()));
        }
        return Rule.Result.ofPlanNode(new UnionNode(context.getIdAllocator().getNextId(), (List<PlanNode>)rewrittenSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet())));
    }
}

