/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushProjectionThroughUnion
implements Rule<ProjectNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        UnionNode source = (UnionNode)captures.get(CHILD);
        List<Symbol> outputLayout = parent.getOutputSymbols();
        ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
        ImmutableList.Builder outputSources = ImmutableList.builder();
        for (int i = 0; i < source.getSources().size(); ++i) {
            Map<Symbol, SymbolReference> outputToInput = source.sourceSymbolMap(i);
            Assignments.Builder assignments = Assignments.builder();
            HashMap<Symbol, Symbol> projectSymbolMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> entry : parent.getAssignments().entrySet()) {
                Expression translatedExpression = PushProjectionThroughUnion.translateExpression(entry.getValue(), outputToInput);
                Type type = context.getSymbolAllocator().getTypes().get(entry.getKey());
                Symbol symbol2 = context.getSymbolAllocator().newSymbol(translatedExpression, type);
                assignments.put(symbol2, translatedExpression);
                projectSymbolMapping.put(entry.getKey(), symbol2);
            }
            outputSources.add((Object)new ProjectNode(context.getIdAllocator().getNextId(), source.getSources().get(i), assignments.build()));
            outputLayout.forEach(symbol -> mappings.put(symbol, projectSymbolMapping.get(symbol)));
        }
        return Rule.Result.ofPlanNode(new UnionNode(parent.getId(), (List<PlanNode>)outputSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet())));
    }

    private static Expression translateExpression(Expression inputExpression, Map<Symbol, SymbolReference> symbolMapping) {
        return new ExpressionSymbolInliner(symbolMapping::get).rewrite(inputExpression);
    }
}

