/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushProjectionThroughExchange
implements Rule<ProjectNode> {
    private static final Capture<ExchangeNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(project -> !PushProjectionThroughExchange.isSymbolToSymbolProjection(project)).with(Patterns.source().matching(Patterns.exchange().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        ExchangeNode exchange = (ExchangeNode)captures.get(CHILD);
        ImmutableList.Builder newSourceBuilder = ImmutableList.builder();
        ImmutableList.Builder inputsBuilder = ImmutableList.builder();
        for (int i = 0; i < exchange.getSources().size(); ++i) {
            Map<Symbol, SymbolReference> outputToInputMap = PushProjectionThroughExchange.extractExchangeOutputToInput(exchange, i);
            Assignments.Builder builder = Assignments.builder();
            ImmutableList.Builder inputs = ImmutableList.builder();
            exchange.getPartitioningScheme().getPartitioning().getColumns().stream().map(outputToInputMap::get).forEach(nameReference -> {
                Symbol symbol = Symbol.from((Expression)nameReference);
                projections.put(symbol, (Expression)nameReference);
                inputs.add((Object)symbol);
            });
            if (exchange.getPartitioningScheme().getHashColumn().isPresent()) {
                builder.put(exchange.getPartitioningScheme().getHashColumn().get(), (Expression)exchange.getPartitioningScheme().getHashColumn().get().toSymbolReference());
                inputs.add((Object)exchange.getPartitioningScheme().getHashColumn().get());
            }
            for (Map.Entry<Symbol, Expression> projection : project.getAssignments().entrySet()) {
                Expression translatedExpression = PushProjectionThroughExchange.translateExpression(projection.getValue(), outputToInputMap);
                Type type = context.getSymbolAllocator().getTypes().get(projection.getKey());
                Symbol symbol = context.getSymbolAllocator().newSymbol(translatedExpression, type);
                builder.put(symbol, translatedExpression);
                inputs.add((Object)symbol);
            }
            newSourceBuilder.add((Object)new ProjectNode(context.getIdAllocator().getNextId(), exchange.getSources().get(i), builder.build()));
            inputsBuilder.add((Object)inputs.build());
        }
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        exchange.getPartitioningScheme().getPartitioning().getColumns().forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        if (exchange.getPartitioningScheme().getHashColumn().isPresent()) {
            outputBuilder.add((Object)exchange.getPartitioningScheme().getHashColumn().get());
        }
        for (Map.Entry entry : project.getAssignments().entrySet()) {
            outputBuilder.add(entry.getKey());
        }
        PartitioningScheme partitioningScheme = new PartitioningScheme(exchange.getPartitioningScheme().getPartitioning(), (List<Symbol>)outputBuilder.build(), exchange.getPartitioningScheme().getHashColumn(), exchange.getPartitioningScheme().isReplicateNullsAndAny(), exchange.getPartitioningScheme().getBucketToPartition());
        ExchangeNode exchangeNode = new ExchangeNode(exchange.getId(), exchange.getType(), exchange.getScope(), partitioningScheme, (List<PlanNode>)newSourceBuilder.build(), (List<List<Symbol>>)inputsBuilder.build());
        return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), exchangeNode, (Set<Symbol>)ImmutableSet.copyOf(project.getOutputSymbols())).orElse(exchangeNode));
    }

    private static boolean isSymbolToSymbolProjection(ProjectNode project) {
        return project.getAssignments().getExpressions().stream().allMatch(e -> e instanceof SymbolReference);
    }

    private static Map<Symbol, SymbolReference> extractExchangeOutputToInput(ExchangeNode exchange, int sourceIndex) {
        HashMap<Symbol, SymbolReference> outputToInputMap = new HashMap<Symbol, SymbolReference>();
        for (int i = 0; i < exchange.getOutputSymbols().size(); ++i) {
            outputToInputMap.put(exchange.getOutputSymbols().get(i), exchange.getInputs().get(sourceIndex).get(i).toSymbolReference());
        }
        return outputToInputMap;
    }

    private static Expression translateExpression(Expression inputExpression, Map<Symbol, SymbolReference> symbolMapping) {
        return new ExpressionSymbolInliner(symbolMapping::get).rewrite(inputExpression);
    }
}

