/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneIndexSourceColumns
extends ProjectOffPushDownRule<IndexSourceNode> {
    public PruneIndexSourceColumns() {
        super(Patterns.indexSource());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, IndexSourceNode indexSourceNode, Set<Symbol> referencedOutputs) {
        Set prunedLookupSymbols = (Set)indexSourceNode.getLookupSymbols().stream().filter(referencedOutputs::contains).collect(ImmutableSet.toImmutableSet());
        Map prunedAssignments = Maps.filterEntries(indexSourceNode.getAssignments(), entry -> referencedOutputs.contains(entry.getKey()) || PruneIndexSourceColumns.tupleDomainReferencesColumnHandle(indexSourceNode.getEffectiveTupleDomain(), (ColumnHandle)entry.getValue()));
        List prunedOutputList = (List)indexSourceNode.getOutputSymbols().stream().filter(referencedOutputs::contains).collect(ImmutableList.toImmutableList());
        return Optional.of(new IndexSourceNode(indexSourceNode.getId(), indexSourceNode.getIndexHandle(), indexSourceNode.getTableHandle(), indexSourceNode.getLayout(), prunedLookupSymbols, prunedOutputList, prunedAssignments, indexSourceNode.getEffectiveTupleDomain()));
    }

    private static boolean tupleDomainReferencesColumnHandle(TupleDomain<ColumnHandle> tupleDomain, ColumnHandle columnHandle) {
        return tupleDomain.getDomains().map(domains -> domains.containsKey(columnHandle)).orElse(false);
    }
}

