/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(aggregation -> ImplementFilteredAggregations.hasFilters(aggregation));

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getCall().getFilter().isPresent() && !e.getMask().isPresent());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregation, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregation.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            FunctionCall call = entry.getValue().getCall();
            Optional<Symbol> mask = entry.getValue().getMask();
            if (call.getFilter().isPresent()) {
                Expression filter = (Expression)call.getFilter().get();
                Symbol symbol = context.getSymbolAllocator().newSymbol(filter, (Type)BooleanType.BOOLEAN);
                newAssignments.put(symbol, filter);
                mask = Optional.of(symbol);
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(new FunctionCall(call.getName(), call.getWindow(), Optional.empty(), call.isDistinct(), call.getArguments()), entry.getValue().getSignature(), mask));
        }
        newAssignments.putIdentities(aggregation.getSource().getOutputSymbols());
        return Rule.Result.ofPlanNode(new AggregationNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), aggregation.getSource(), newAssignments.build()), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregation.getGroupingSets(), aggregation.getStep(), aggregation.getHashSymbol(), aggregation.getGroupIdSymbol()));
    }
}

