/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleSet;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ExpressionRewriteRuleSet
implements RuleSet {
    private final ExpressionRewriter rewriter;

    public ExpressionRewriteRuleSet(ExpressionRewriter rewrite) {
        this.rewriter = rewrite;
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ProjectExpressionRewrite(this.rewriter), (Object)new AggregationExpressionRewrite(this.rewriter), (Object)new FilterExpressionRewrite(this.rewriter), (Object)new TableScanExpressionRewrite(this.rewriter), (Object)new JoinExpressionRewrite(this.rewriter), (Object)new ValuesExpressionRewrite(this.rewriter), (Object[])new Rule[]{new ApplyExpressionRewrite(this.rewriter)});
    }

    public static final class ApplyExpressionRewrite
    implements Rule<ApplyNode> {
        private final ExpressionRewriter rewriter;

        public ApplyExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ApplyNode> getPattern() {
            return Patterns.applyNode();
        }

        @Override
        public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
            Assignments subqueryAssignments = applyNode.getSubqueryAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (applyNode.getSubqueryAssignments().equals(subqueryAssignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ApplyNode(applyNode.getId(), applyNode.getInput(), applyNode.getSubquery(), subqueryAssignments, applyNode.getCorrelation(), applyNode.getOriginSubquery()));
        }
    }

    public static final class ValuesExpressionRewrite
    implements Rule<ValuesNode> {
        private final ExpressionRewriter rewriter;

        public ValuesExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List<Expression> row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (Expression expression : row) {
                    Expression rewritten;
                    if (!expression.equals((Object)(rewritten = this.rewriter.rewrite(expression, context)))) {
                        anyRewritten = true;
                    }
                    newRow.add((Object)rewritten);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<List<Expression>>)rows.build()));
            }
            return Rule.Result.empty();
        }
    }

    public static final class JoinExpressionRewrite
    implements Rule<JoinNode> {
        private final ExpressionRewriter rewriter;

        public JoinExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return Patterns.join();
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Optional<Expression> filter = joinNode.getFilter().map(x -> this.rewriter.rewrite((Expression)x, context));
            if (!joinNode.getFilter().equals(filter)) {
                return Rule.Result.ofPlanNode(new JoinNode(joinNode.getId(), joinNode.getType(), joinNode.getLeft(), joinNode.getRight(), joinNode.getCriteria(), joinNode.getOutputSymbols(), filter, joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType()));
            }
            return Rule.Result.empty();
        }
    }

    public static final class TableScanExpressionRewrite
    implements Rule<TableScanNode> {
        private final ExpressionRewriter rewriter;

        public TableScanExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return Patterns.tableScan();
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            if (tableScanNode.getOriginalConstraint() == null) {
                return Rule.Result.empty();
            }
            Expression rewrittenOriginalContraint = this.rewriter.rewrite(tableScanNode.getOriginalConstraint(), context);
            if (!tableScanNode.getOriginalConstraint().equals((Object)rewrittenOriginalContraint)) {
                return Rule.Result.ofPlanNode(new TableScanNode(tableScanNode.getId(), tableScanNode.getTable(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), tableScanNode.getLayout(), tableScanNode.getCurrentConstraint(), rewrittenOriginalContraint));
            }
            return Rule.Result.empty();
        }
    }

    public static final class FilterExpressionRewrite
    implements Rule<FilterNode> {
        private final ExpressionRewriter rewriter;

        public FilterExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Expression rewritten = this.rewriter.rewrite(filterNode.getPredicate(), context);
            if (filterNode.getPredicate().equals((Object)rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new FilterNode(filterNode.getId(), filterNode.getSource(), rewritten));
        }
    }

    public static final class AggregationExpressionRewrite
    implements Rule<AggregationNode> {
        private final ExpressionRewriter rewriter;

        public AggregationExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<AggregationNode> getPattern() {
            return Patterns.aggregation();
        }

        @Override
        public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableMap.Builder aggregations = ImmutableMap.builder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> aggregation : aggregationNode.getAggregations().entrySet()) {
                FunctionCall call = (FunctionCall)this.rewriter.rewrite((Expression)aggregation.getValue().getCall(), context);
                aggregations.put((Object)aggregation.getKey(), (Object)new AggregationNode.Aggregation(call, aggregation.getValue().getSignature(), aggregation.getValue().getMask()));
                if (aggregation.getValue().getCall().equals((Object)call)) continue;
                anyRewritten = true;
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new AggregationNode(aggregationNode.getId(), aggregationNode.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregationNode.getGroupingSets(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
            }
            return Rule.Result.empty();
        }
    }

    public static final class ProjectExpressionRewrite
    implements Rule<ProjectNode> {
        private final ExpressionRewriter rewriter;

        public ProjectExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
            Assignments assignments = projectNode.getAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (projectNode.getAssignments().equals(assignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ProjectNode(projectNode.getId(), projectNode.getSource(), assignments));
        }
    }

    public static interface ExpressionRewriter {
        public Expression rewrite(Expression var1, Rule.Context var2);
    }
}

