/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.cost.PlanNodeCost;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class Plan {
    private final PlanNode root;
    private final Map<Symbol, Type> types;
    private final Map<PlanNodeId, PlanNodeCost> planNodeCosts;

    public Plan(PlanNode root, Map<Symbol, Type> types, Map<PlanNodeId, PlanNodeCost> planNodeCosts) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(planNodeCosts, "planNodeCosts is null");
        this.root = root;
        this.types = ImmutableMap.copyOf(types);
        this.planNodeCosts = planNodeCosts;
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public Map<Symbol, Type> getTypes() {
        return this.types;
    }

    public Map<PlanNodeId, PlanNodeCost> getPlanNodeCosts() {
        return this.planNodeCosts;
    }
}

