/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.type.ListLiteralType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class GroupingOperationRewriter {
    private GroupingOperationRewriter() {
    }

    public static Expression rewriteGroupingOperation(GroupingOperation expression, QuerySpecification queryNode, Analysis analysis, Metadata metadata, Optional<Symbol> groupIdSymbol) {
        Objects.requireNonNull(queryNode, "node is null");
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
        Preconditions.checkState((boolean)queryNode.getGroupBy().isPresent(), (Object)"GroupBy node must be present");
        if (analysis.getGroupingSets(queryNode).size() == 1) {
            if (GroupingOperationRewriter.shouldUseIntegerReturnType(expression)) {
                return new LongLiteral("0");
            }
            return new GenericLiteral("bigint", "0");
        }
        Preconditions.checkState((boolean)groupIdSymbol.isPresent(), (Object)"groupId symbol is missing");
        Map<NodeRef<Expression>, FieldId> columnReferenceFields = analysis.getColumnReferenceFields();
        RelationId relationId = columnReferenceFields.get(NodeRef.of((Node)((Node)expression.getGroupingColumns().get(0)))).getRelationId();
        List groupingOrdinals = (List)expression.getGroupingColumns().stream().map(NodeRef::of).peek(groupingColumn -> Preconditions.checkState((boolean)columnReferenceFields.containsKey(groupingColumn), (Object)"the grouping column is not in the columnReferencesField map")).map(columnReferenceFields::get).map(fieldId -> GroupingOperationRewriter.translateFieldToLongLiteral(fieldId, relationId)).collect(ImmutableList.toImmutableList());
        List groupingSetOrdinals = (List)analysis.getGroupingSets(queryNode).stream().map(groupingSet -> (ImmutableList)groupingSet.stream().map(NodeRef::of).filter(columnReferenceFields::containsKey).map(columnReferenceFields::get).map(fieldId -> GroupingOperationRewriter.translateFieldToLongLiteral(fieldId, relationId)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        ImmutableList newGroupingArguments = ImmutableList.of((Object)groupIdSymbol.get().toSymbolReference(), (Object)new Cast((Expression)new ArrayConstructor(groupingOrdinals), "ListLiteral"), (Object)new Cast((Expression)new ArrayConstructor((List)groupingSetOrdinals.stream().map(ArrayConstructor::new).collect(ImmutableList.toImmutableList())), "ListLiteral"));
        FunctionCall rewritten = new FunctionCall((NodeLocation)expression.getLocation().get(), GroupingOperationRewriter.shouldUseIntegerReturnType(expression) ? QualifiedName.of((String)"integer_grouping") : QualifiedName.of((String)"bigint_grouping"), (List)newGroupingArguments);
        List<TypeSignatureProvider> functionArgumentTypes = Arrays.asList(new TypeSignatureProvider(BigintType.BIGINT.getTypeSignature()), new TypeSignatureProvider(ListLiteralType.LIST_LITERAL.getTypeSignature()), new TypeSignatureProvider(ListLiteralType.LIST_LITERAL.getTypeSignature()));
        ExpressionAnalyzer.resolveFunction(rewritten, functionArgumentTypes, metadata.getFunctionRegistry());
        return rewritten;
    }

    private static Expression translateFieldToLongLiteral(FieldId fieldId, RelationId requiredOriginRelationId) {
        Preconditions.checkState((boolean)fieldId.getRelationId().equals(requiredOriginRelationId), (Object)"grouping arguments must all come from the same relation");
        return new LongLiteral(Integer.toString(fieldId.getFieldIndex()));
    }

    private static boolean shouldUseIntegerReturnType(GroupingOperation groupingOperation) {
        return groupingOperation.getGroupingColumns().size() <= 31;
    }
}

