/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor().process((Node)expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (node.getName().equals((Object)QualifiedName.of((String)"rand")) || node.getName().equals((Object)QualifiedName.of((String)"random")) || node.getName().equals((Object)QualifiedName.of((String)"shuffle")) || node.getName().equals((Object)QualifiedName.of((String)"bigint_grouping")) || node.getName().equals((Object)QualifiedName.of((String)"integer_grouping"))) {
                deterministic.set(false);
            }
            return (Void)super.visitFunctionCall(node, (Object)deterministic);
        }
    }
}

