/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.function.Description;
import io.airlift.configuration.Config;
import javax.validation.constraints.Min;

public class CompilerConfig {
    private boolean interpreterEnabled;
    private int expressionCacheSize = 10000;

    public boolean isInterpreterEnabled() {
        return this.interpreterEnabled;
    }

    @Config(value="compiler.interpreter-enabled")
    @Description(value="Allows evaluation to fall back to interpreter if compilation fails")
    public CompilerConfig setInterpreterEnabled(boolean interpreterEnabled) {
        this.interpreterEnabled = interpreterEnabled;
        return this;
    }

    @Min(value=0L)
    public int getExpressionCacheSize() {
        return this.expressionCacheSize;
    }

    @Config(value="compiler.expression-cache-size")
    @Description(value="Reuse compiled expressions across multiple queries")
    public CompilerConfig setExpressionCacheSize(int expressionCacheSize) {
        this.expressionCacheSize = expressionCacheSize;
        return this;
    }
}

