/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.project.ConstantPageProjection;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFieldsToInputParametersRewriter;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.LambdaAndTryExpressionExtractor;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.DeterminismEvaluator;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.base.VerifyException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class PageFunctionCompiler {
    private final Metadata metadata;
    private final DeterminismEvaluator determinismEvaluator;
    private final LoadingCache<RowExpression, Supplier<PageProjection>> projectionCache;
    private final LoadingCache<RowExpression, Supplier<PageFilter>> filterCache;
    private final CacheStatsMBean projectionCacheStats;
    private final CacheStatsMBean filterCacheStats;

    @Inject
    public PageFunctionCompiler(Metadata metadata, CompilerConfig config) {
        this(metadata, Objects.requireNonNull(config, "config is null").getExpressionCacheSize());
    }

    public PageFunctionCompiler(Metadata metadata, int expressionCacheSize) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.determinismEvaluator = new DeterminismEvaluator(metadata.getFunctionRegistry());
        if (expressionCacheSize > 0) {
            this.projectionCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(projection -> this.compileProjectionInternal((RowExpression)projection, Optional.empty())));
            this.projectionCacheStats = new CacheStatsMBean(this.projectionCache);
        } else {
            this.projectionCache = null;
            this.projectionCacheStats = null;
        }
        if (expressionCacheSize > 0) {
            this.filterCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(filter -> this.compileFilterInternal((RowExpression)filter, Optional.empty())));
            this.filterCacheStats = new CacheStatsMBean(this.filterCache);
        } else {
            this.filterCache = null;
            this.filterCacheStats = null;
        }
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getProjectionCache() {
        return this.projectionCacheStats;
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getFilterCache() {
        return this.filterCacheStats;
    }

    public Supplier<PageProjection> compileProjection(RowExpression projection, Optional<String> classNameSuffix) {
        if (this.projectionCache == null) {
            return this.compileProjectionInternal(projection, classNameSuffix);
        }
        return (Supplier)this.projectionCache.getUnchecked((Object)projection);
    }

    private Supplier<PageProjection> compileProjectionInternal(RowExpression projection, Optional<String> classNameSuffix) {
        Class projectionClass;
        Objects.requireNonNull(projection, "projection is null");
        if (projection instanceof InputReferenceExpression) {
            InputReferenceExpression input = (InputReferenceExpression)projection;
            InputPageProjection projectionFunction = new InputPageProjection(input.getField(), input.getType());
            return () -> projectionFunction;
        }
        if (projection instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)projection;
            ConstantPageProjection projectionFunction = new ConstantPageProjection(constant.getValue(), constant.getType());
            return () -> projectionFunction;
        }
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(projection);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.defineProjectionClass(result.getRewrittenExpression(), result.getInputChannels(), callSiteBinder, classNameSuffix);
        try {
            projectionClass = CompilerUtils.defineClass((ClassDefinition)classDefinition, PageProjection.class, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
        }
        return () -> {
            try {
                return (PageProjection)projectionClass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private static ParameterizedType generateProjectionClassName(Optional<String> classNameSuffix) {
        StringBuilder className = new StringBuilder(PageProjection.class.getSimpleName());
        classNameSuffix.ifPresent(suffix -> className.append("_").append(suffix.replace('.', '_')));
        return CompilerUtils.makeClassName((String)className.toString());
    }

    private ClassDefinition defineProjectionClass(RowExpression projection, InputChannels inputChannels, CallSiteBinder callSiteBinder, Optional<String> classNameSuffix) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateProjectionClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageProjection.class)});
        FieldDefinition blockBuilderField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "blockBuilder", BlockBuilder.class);
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        PageFunctionCompiler.generatePageProjectMethod(classDefinition, blockBuilderField);
        PreGeneratedExpressions preGeneratedExpressions = this.generateMethodsForLambdaAndTry(classDefinition, callSiteBinder, cachedInstanceBinder, projection);
        this.generateProjectMethod(classDefinition, callSiteBinder, cachedInstanceBinder, preGeneratedExpressions, projection, blockBuilderField);
        BytecodeExpression type = BytecodeUtils.invoke(callSiteBinder.bind(projection.getType(), Type.class), "type");
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getType", ParameterizedType.type(Type.class), new Parameter[0]).getBody().append((BytecodeNode)type.ret());
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isDeterministic", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)this.determinismEvaluator.isDeterministic(projection)).ret());
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(InputChannels.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputChannels, InputChannels.class), "getInputChannels").ret());
        String toStringResult = MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("projection", (Object)projection).toString();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(toStringResult, String.class), "toString").ret());
        PageFunctionCompiler.generateConstructor(classDefinition, cachedInstanceBinder, preGeneratedExpressions, method -> {
            Variable thisVariable = method.getThis();
            BytecodeBlock body = method.getBody();
            body.append((BytecodeNode)thisVariable.setField(blockBuilderField, type.invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0]), BytecodeExpressions.constantInt((int)1)})));
        });
        return classDefinition;
    }

    private static MethodDefinition generatePageProjectMethod(ClassDefinition classDefinition, FieldDefinition blockBuilder) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", SelectedPositions.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "project", ParameterizedType.type(Block.class), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).build());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable from = scope.declareVariable("from", body, selectedPositions.invoke("getOffset", Integer.TYPE, new BytecodeExpression[0]));
        Variable to = scope.declareVariable("to", body, BytecodeExpressions.add((BytecodeExpression)from, (BytecodeExpression)selectedPositions.invoke("size", Integer.TYPE, new BytecodeExpression[0])));
        Variable positions = scope.declareVariable(int[].class, "positions");
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        body.append((BytecodeNode)thisVariable.setField(blockBuilder, thisVariable.getField(blockBuilder).invoke("newBlockBuilderLike", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0])})));
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)selectedPositions.invoke("isList", Boolean.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)ifStatement);
        ifStatement.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positions.set(selectedPositions.invoke("getPositions", int[].class, new BytecodeExpression[0]))).append((BytecodeNode)new ForLoop("positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)thisVariable.invoke("project", Void.TYPE, new BytecodeExpression[]{session, page, positions.getElement((BytecodeExpression)index)}))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("range based loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)thisVariable.invoke("project", Void.TYPE, new BytecodeExpression[]{session, page, index})));
        Variable block = scope.declareVariable(Block.class, "block");
        body.append((BytecodeNode)block.set(thisVariable.getField(blockBuilder).invoke("build", Block.class, new BytecodeExpression[0]))).append((BytecodeNode)block.ret());
        return method;
    }

    private MethodDefinition generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, PreGeneratedExpressions preGeneratedExpressions, RowExpression projection, FieldDefinition blockBuilder) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "project", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)position).build());
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        PageFunctionCompiler.declareBlockVariables(projection, page, scope, body);
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, PageFunctionCompiler.fieldReferenceCompiler(callSiteBinder), this.metadata.getFunctionRegistry(), preGeneratedExpressions);
        body.append((BytecodeNode)thisVariable.getField(blockBuilder)).append(compiler.compile(projection, scope)).append(BytecodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
        return method;
    }

    public Supplier<PageFilter> compileFilter(RowExpression filter, Optional<String> classNameSuffix) {
        if (this.filterCache == null) {
            return this.compileFilterInternal(filter, classNameSuffix);
        }
        return (Supplier)this.filterCache.getUnchecked((Object)filter);
    }

    private Supplier<PageFilter> compileFilterInternal(RowExpression filter, Optional<String> classNameSuffix) {
        Class functionClass;
        Objects.requireNonNull(filter, "filter is null");
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(filter);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.defineFilterClass(result.getRewrittenExpression(), result.getInputChannels(), callSiteBinder, classNameSuffix);
        try {
            functionClass = CompilerUtils.defineClass((ClassDefinition)classDefinition, PageFilter.class, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, filter.toString(), e.getCause());
        }
        return () -> {
            try {
                return (PageFilter)functionClass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private static ParameterizedType generateFilterClassName(Optional<String> classNameSuffix) {
        StringBuilder className = new StringBuilder(PageFilter.class.getSimpleName());
        classNameSuffix.ifPresent(suffix -> className.append("_").append(suffix.replace('.', '_')));
        return CompilerUtils.makeClassName((String)className.toString());
    }

    private ClassDefinition defineFilterClass(RowExpression filter, InputChannels inputChannels, CallSiteBinder callSiteBinder, Optional<String> classNameSuffix) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateFilterClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageFilter.class)});
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        PreGeneratedExpressions preGeneratedExpressions = this.generateMethodsForLambdaAndTry(classDefinition, callSiteBinder, cachedInstanceBinder, filter);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, preGeneratedExpressions, filter);
        FieldDefinition selectedPositions = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "selectedPositions", boolean[].class);
        PageFunctionCompiler.generatePageFilterMethod(classDefinition, selectedPositions);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isDeterministic", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)this.determinismEvaluator.isDeterministic(filter))).retBoolean();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(InputChannels.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputChannels, InputChannels.class), "getInputChannels")).retObject();
        String toStringResult = MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).toString();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(toStringResult, String.class), "toString")).retObject();
        PageFunctionCompiler.generateConstructor(classDefinition, cachedInstanceBinder, preGeneratedExpressions, method -> {
            Variable thisVariable = method.getScope().getThis();
            method.getBody().append((BytecodeNode)thisVariable.setField(selectedPositions, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (int)0)));
        });
        return classDefinition;
    }

    private static MethodDefinition generatePageFilterMethod(ClassDefinition classDefinition, FieldDefinition selectedPositionsField) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(SelectedPositions.class), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).build());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)new IfStatement("grow selectedPositions if necessary", new Object[0]).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)thisVariable.getField(selectedPositionsField).length(), (BytecodeExpression)positionCount)).ifTrue((BytecodeNode)thisVariable.setField(selectedPositionsField, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (BytecodeExpression)positionCount))));
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.getField(selectedPositionsField));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)selectedPositions.setElement((BytecodeExpression)position, thisVariable.invoke("filter", Boolean.TYPE, new BytecodeExpression[]{session, page, position}))));
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(PageFilter.class, (String)"positionsArrayToSelectedPositions", SelectedPositions.class, (BytecodeExpression[])new BytecodeExpression[]{selectedPositions, positionCount}).ret());
        return method;
    }

    private MethodDefinition generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, PreGeneratedExpressions preGeneratedExpressions, RowExpression filter) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)position).build());
        method.comment("Filter: %s", new Object[]{filter.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        PageFunctionCompiler.declareBlockVariables(filter, page, scope, body);
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, PageFunctionCompiler.fieldReferenceCompiler(callSiteBinder), this.metadata.getFunctionRegistry(), preGeneratedExpressions);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(compiler.compile(filter, scope)).putVariable(result).append((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)wasNullVariable), (BytecodeExpression)result).ret());
        return method;
    }

    private PreGeneratedExpressions generateMethodsForLambdaAndTry(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression) {
        ImmutableSet lambdaAndTryExpressions = ImmutableSet.copyOf(LambdaAndTryExpressionExtractor.extractLambdaAndTryExpressions(expression));
        ImmutableMap.Builder tryMethodMap = ImmutableMap.builder();
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (RowExpression lambdaOrTryExpression : lambdaAndTryExpressions) {
            if (!(lambdaOrTryExpression instanceof LambdaDefinitionExpression)) {
                throw new VerifyException(String.format("unexpected expression: %s", lambdaOrTryExpression.toString()));
            }
            LambdaDefinitionExpression lambdaExpression = (LambdaDefinitionExpression)lambdaOrTryExpression;
            PreGeneratedExpressions preGeneratedExpressions = new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build());
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, preGeneratedExpressions, callSiteBinder, cachedInstanceBinder, this.metadata.getFunctionRegistry());
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build());
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder, PreGeneratedExpressions preGeneratedExpressions, Consumer<MethodDefinition> additionalStatements) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        additionalStatements.accept(constructorDefinition);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        for (LambdaBytecodeGenerator.CompiledLambda compiledLambda : preGeneratedExpressions.getCompiledLambdaMap().values()) {
            compiledLambda.generateInitialization(thisVariable, body);
        }
        body.ret();
    }

    private static void declareBlockVariables(RowExpression expression, Parameter page, Scope scope, BytecodeBlock body) {
        for (int channel : PageFunctionCompiler.getInputChannels(expression)) {
            scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
        }
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageFunctionCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg((String)("block_" + channel), Block.class));
        }
        return parameters.build();
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(CallSiteBinder callSiteBinder) {
        return new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> scope.getVariable("position"), callSiteBinder);
    }
}

