/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.LambdaCapture;
import com.facebook.presto.sql.gen.ParameterAndType;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class LambdaBytecodeGenerator {
    private LambdaBytecodeGenerator() {
    }

    public static CompiledLambda preGenerateLambdaExpression(LambdaDefinitionExpression lambdaExpression, String fieldName, ClassDefinition classDefinition, PreGeneratedExpressions preGeneratedExpressions, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionRegistry functionRegistry) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder();
        parameters.add((Object)Parameter.arg((String)"session", ConnectorSession.class));
        for (int i = 0; i < lambdaExpression.getArguments().size(); ++i) {
            Class type = Primitives.wrap((Class)lambdaExpression.getArgumentTypes().get(i).getJavaType());
            String argumentName = lambdaExpression.getArguments().get(i);
            Parameter arg = Parameter.arg((String)("lambda_" + argumentName), (Class)type);
            parameters.add((Object)arg);
            parameterMapBuilder.put((Object)argumentName, (Object)new ParameterAndType(arg, type));
        }
        RowExpressionCompiler innerExpressionCompiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)parameterMapBuilder.build()), functionRegistry, preGeneratedExpressions);
        return LambdaBytecodeGenerator.defineLambdaMethodAndField(innerExpressionCompiler, classDefinition, fieldName, (List<Parameter>)parameters.build(), lambdaExpression);
    }

    private static CompiledLambda defineLambdaMethodAndField(RowExpressionCompiler innerExpressionCompiler, ClassDefinition classDefinition, String fieldAndMethodName, List<Parameter> inputParameters, LambdaDefinitionExpression lambda) {
        Failures.checkCondition(inputParameters.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for lambda expression", new Object[0]);
        Class returnType = Primitives.wrap((Class)lambda.getBody().getType().getJavaType());
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), fieldAndMethodName, ParameterizedType.type((Class)returnType), inputParameters);
        Scope scope = method.getScope();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        BytecodeNode compiledBody = innerExpressionCompiler.compile(lambda.getBody(), scope);
        method.getBody().putVariable(wasNull, false).append(compiledBody).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, returnType)).ret(returnType);
        FieldDefinition staticField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), fieldAndMethodName, ParameterizedType.type(MethodHandle.class));
        FieldDefinition instanceField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "binded_" + fieldAndMethodName, ParameterizedType.type(MethodHandle.class));
        classDefinition.getClassInitializer().getBody().append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)staticField, (BytecodeExpression)BytecodeExpressions.invokeStatic(Reflection.class, (String)"methodHandle", MethodHandle.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)classDefinition.getType()), BytecodeExpressions.constantString((String)fieldAndMethodName), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (Iterable)((Iterable)inputParameters.stream().map(BytecodeExpression::getType).map(BytecodeExpressions::constantClass).collect(ImmutableList.toImmutableList())))})));
        Handle lambdaAsmHandle = new Handle(5, method.getThis().getType().getClassName(), method.getName(), method.getMethodDescriptor());
        return new CompiledLambda(lambdaAsmHandle, method.getReturnType(), method.getParameterTypes(), staticField, instanceField);
    }

    public static BytecodeNode generateLambda(BytecodeGeneratorContext context, List<RowExpression> captureExpressions, CompiledLambda compiledLambda, Class lambdaInterface) {
        if (!lambdaInterface.isAnnotationPresent(FunctionalInterface.class)) {
            throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
        }
        BytecodeBlock block = new BytecodeBlock().setDescription("Partial apply");
        Scope scope = context.getScope();
        Variable wasNull = scope.getVariable("wasNull");
        ImmutableList.Builder captureVariableBuilder = ImmutableList.builder();
        for (RowExpression captureExpression : captureExpressions) {
            Class valueType = Primitives.wrap((Class)captureExpression.getType().getJavaType());
            Variable valueVariable = scope.createTempVariable(valueType);
            block.append(context.generate(captureExpression));
            block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, valueType));
            block.putVariable(valueVariable);
            block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            captureVariableBuilder.add((Object)valueVariable);
        }
        ImmutableList captureVariables = ImmutableList.builder().add((Object[])new BytecodeExpression[]{scope.getThis(), scope.getVariable("session")}).addAll((Iterable)captureVariableBuilder.build()).build();
        Type instantiatedMethodAsmType = Type.getMethodType((Type)compiledLambda.getReturnType().getAsmType(), (Type[])((Type[])((ImmutableList)compiledLambda.getParameterTypes().stream().skip(captureExpressions.size() + 1).map(ParameterizedType::getAsmType).collect(ImmutableList.toImmutableList())).toArray((Object[])new Type[0])));
        block.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)LambdaCapture.LAMBDA_CAPTURE_METHOD, (Iterable)ImmutableList.of((Object)Type.getType((Method)LambdaBytecodeGenerator.getSingleApplyMethod(lambdaInterface)), (Object)compiledLambda.getLambdaAsmHandle(), (Object)instantiatedMethodAsmType), (String)"apply", (ParameterizedType)ParameterizedType.type((Class)lambdaInterface), (Iterable)captureVariables));
        return block;
    }

    private static Method getSingleApplyMethod(Class lambdaFunctionInterface) {
        Failures.checkCondition(lambdaFunctionInterface.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Lambda function interface is required to be annotated with FunctionalInterface", new Object[0]);
        List applyMethods = (List)Arrays.stream(lambdaFunctionInterface.getMethods()).filter(method -> method.getName().equals("apply")).collect(ImmutableList.toImmutableList());
        Failures.checkCondition(applyMethods.size() == 1, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Expect to have exactly 1 method with name 'apply' in interface " + lambdaFunctionInterface.getName(), new Object[0]);
        return (Method)applyMethods.get(0);
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> variableReferenceCompiler(final Map<String, ParameterAndType> parameterMap) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                ParameterAndType parameterAndType = (ParameterAndType)parameterMap.get(reference.getName());
                Parameter parameter = parameterAndType.getParameter();
                Class<?> type = parameterAndType.getType();
                return new BytecodeBlock().append((BytecodeNode)parameter).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, type));
            }
        };
    }

    static class CompiledLambda {
        private final FieldDefinition staticField;
        private final FieldDefinition instanceField;
        private final Handle lambdaAsmHandle;
        private final ParameterizedType returnType;
        private final List<ParameterizedType> parameterTypes;

        public CompiledLambda(Handle lambdaAsmHandle, ParameterizedType returnType, List<ParameterizedType> parameterTypes, FieldDefinition staticField, FieldDefinition instanceField) {
            this.staticField = Objects.requireNonNull(staticField, "staticField is null");
            this.instanceField = Objects.requireNonNull(instanceField, "instanceField is null");
            this.lambdaAsmHandle = Objects.requireNonNull(lambdaAsmHandle, "lambdaMethodAsmHandle is null");
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "returnType is null"));
        }

        public Handle getLambdaAsmHandle() {
            return this.lambdaAsmHandle;
        }

        public ParameterizedType getReturnType() {
            return this.returnType;
        }

        public List<ParameterizedType> getParameterTypes() {
            return this.parameterTypes;
        }

        public FieldDefinition getInstanceField() {
            return this.instanceField;
        }

        public void generateInitialization(Variable thisVariable, BytecodeBlock block) {
            block.append((BytecodeNode)thisVariable.setField(this.instanceField, BytecodeExpressions.getStatic((FieldDefinition)this.staticField).invoke("bindTo", MethodHandle.class, new BytecodeExpression[]{thisVariable.cast(Object.class)})));
        }
    }
}

