/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.LookupSwitch;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.util.FastutilSetHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InCodeGenerator
implements BytecodeGenerator {
    private final FunctionRegistry registry;

    public InCodeGenerator(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    @VisibleForTesting
    static SwitchGenerationCase checkSwitchGenerationCase(Type type, List<RowExpression> values) {
        if (values.size() > 32) {
            return SwitchGenerationCase.SET_CONTAINS;
        }
        if (!(type instanceof IntegerType || type instanceof BigintType || type instanceof DateType)) {
            return SwitchGenerationCase.HASH_SWITCH;
        }
        for (RowExpression expression : values) {
            long longConstant;
            Object constant;
            if (!(expression instanceof ConstantExpression) || (constant = ((ConstantExpression)expression).getValue()) == null || (longConstant = ((Number)constant).longValue()) >= Integer.MIN_VALUE && longConstant <= Integer.MAX_VALUE) continue;
            return SwitchGenerationCase.HASH_SWITCH;
        }
        return SwitchGenerationCase.DIRECT_SWITCH;
    }

    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        BytecodeBlock switchBlock;
        BytecodeNode value = generatorContext.generate(arguments.get(0));
        List<RowExpression> values = arguments.subList(1, arguments.size());
        ImmutableList.Builder valuesBytecode = ImmutableList.builder();
        for (int i = 1; i < arguments.size(); ++i) {
            BytecodeNode testNode = generatorContext.generate(arguments.get(i));
            valuesBytecode.add((Object)testNode);
        }
        Type type = arguments.get(0).getType();
        Class<Object> javaType = type.getJavaType();
        SwitchGenerationCase switchGenerationCase = InCodeGenerator.checkSwitchGenerationCase(type, values);
        Signature hashCodeSignature = Signature.internalOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type));
        MethodHandle hashCodeFunction = generatorContext.getRegistry().getScalarFunctionImplementation(hashCodeSignature).getMethodHandle();
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (RowExpression testValue : values) {
            BytecodeNode testBytecode = generatorContext.generate(testValue);
            if (testValue instanceof ConstantExpression && ((ConstantExpression)testValue).getValue() != null) {
                ConstantExpression constant = (ConstantExpression)testValue;
                Object object = constant.getValue();
                switch (switchGenerationCase) {
                    case DIRECT_SWITCH: 
                    case SET_CONTAINS: {
                        constantValuesBuilder.add(object);
                        break;
                    }
                    case HASH_SWITCH: {
                        try {
                            int hashCode = Math.toIntExact(Long.hashCode(hashCodeFunction.invoke(object)));
                            hashBucketsBuilder.put((Object)hashCode, (Object)testBytecode);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + object, throwable);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
                    }
                }
                continue;
            }
            defaultBucket.add((Object)testBytecode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        Scope scope = generatorContext.getScope();
        BytecodeBlock switchCaseBlocks = new BytecodeBlock();
        LookupSwitch.LookupSwitchBuilder switchBuilder = LookupSwitch.lookupSwitchBuilder();
        switch (switchGenerationCase) {
            case DIRECT_SWITCH: {
                for (Object constantValue : constantValues) {
                    switchBuilder.addCase(Math.toIntExact((Long)constantValue), match);
                }
                switchBuilder.defaultCase(defaultLabel);
                switchBlock = new BytecodeBlock().comment("lookupSwitch(<stackValue>))").dup((Class)javaType).append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().dup((Class)javaType).invokeStatic(InCodeGenerator.class, "isInteger", Boolean.TYPE, new Class[]{Long.TYPE})).ifFalse((BytecodeNode)new BytecodeBlock().pop((Class)javaType).gotoLabel(defaultLabel))).longToInt().append((BytecodeNode)switchBuilder.build());
                break;
            }
            case HASH_SWITCH: {
                for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                    LabelNode label = new LabelNode("inHash" + bucket.getKey());
                    switchBuilder.addCase(((Integer)bucket.getKey()).intValue(), label);
                    Collection testValues = (Collection)bucket.getValue();
                    BytecodeBlock caseBlock = InCodeGenerator.buildInCase(generatorContext, scope, type, label, match, defaultLabel, testValues, false);
                    switchCaseBlocks.append((BytecodeNode)caseBlock.setDescription("case " + bucket.getKey()));
                }
                switchBuilder.defaultCase(defaultLabel);
                Binding hashCodeBinding = generatorContext.getCallSiteBinder().bind(hashCodeFunction);
                switchBlock = new BytecodeBlock().comment("lookupSwitch(hashCode(<stackValue>))").dup((Class)javaType).append((BytecodeNode)BytecodeUtils.invoke(hashCodeBinding, hashCodeSignature)).invokeStatic(Long.class, "hashCode", Integer.TYPE, new Class[]{Long.TYPE}).append((BytecodeNode)switchBuilder.build()).append((BytecodeNode)switchCaseBlocks);
                break;
            }
            case SET_CONTAINS: {
                Set<?> constantValuesSet = FastutilSetHelper.toFastutilHashSet(constantValues, type, this.registry);
                Binding constant = generatorContext.getCallSiteBinder().bind(constantValuesSet, constantValuesSet.getClass());
                switchBlock = new BytecodeBlock().comment("inListSet.contains(<stackValue>)").append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().comment("value").dup((Class)javaType).comment("set").append((BytecodeNode)BytecodeUtils.loadConstant(constant)).invokeStatic(FastutilSetHelper.class, "in", Boolean.TYPE, new Class[]{javaType.isPrimitive() ? javaType : Object.class, constantValuesSet.getClass()})).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)match)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
            }
        }
        BytecodeBlock defaultCaseBlock = InCodeGenerator.buildInCase(generatorContext, scope, type, defaultLabel, match, noMatch, (Collection<BytecodeNode>)defaultBucket.build(), true).setDescription("default");
        BytecodeBlock block = new BytecodeBlock().comment("IN").append(value).append(BytecodeUtils.ifWasNullPopAndGoto(scope, end, Boolean.TYPE, javaType)).append((BytecodeNode)switchBlock).append((BytecodeNode)defaultCaseBlock);
        BytecodeBlock matchBlock = new BytecodeBlock().setDescription("match").visitLabel(match).pop(javaType).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse())).push(true).gotoLabel(end);
        block.append((BytecodeNode)matchBlock);
        BytecodeBlock noMatchBlock = new BytecodeBlock().setDescription("noMatch").visitLabel(noMatch).pop(javaType).push(false).gotoLabel(end);
        block.append((BytecodeNode)noMatchBlock);
        block.visitLabel(end);
        return block;
    }

    public static boolean isInteger(long value) {
        return value == (long)((int)value);
    }

    private static BytecodeBlock buildInCase(BytecodeGeneratorContext generatorContext, Scope scope, Type type, LabelNode caseLabel, LabelNode matchLabel, LabelNode noMatchLabel, Collection<BytecodeNode> testValues, boolean checkForNulls) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = scope.createTempVariable(Boolean.TYPE);
        }
        BytecodeBlock caseBlock = new BytecodeBlock().visitLabel(caseLabel);
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull, false);
        }
        LabelNode elseLabel = new LabelNode("else");
        BytecodeBlock elseBlock = new BytecodeBlock().visitLabel(elseLabel);
        Variable wasNull = generatorContext.wasNull();
        if (checkForNulls) {
            elseBlock.append((BytecodeNode)wasNull.set((BytecodeExpression)caseWasNull));
        }
        elseBlock.gotoLabel(noMatchLabel);
        ScalarFunctionImplementation operator = generatorContext.getRegistry().getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)));
        Binding equalsFunction = generatorContext.getCallSiteBinder().bind(operator.getMethodHandle());
        BytecodeBlock elseNode = elseBlock;
        for (BytecodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement test = new IfStatement();
            test.condition().visitLabel(testLabel).dup(type.getJavaType()).append(testNode);
            if (checkForNulls) {
                IfStatement wasNullCheck = new IfStatement("if wasNull, set caseWasNull to true, clear wasNull, pop 2 values of type, and goto next test value", new Object[0]);
                wasNullCheck.condition((BytecodeNode)wasNull);
                wasNullCheck.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)caseWasNull.set(BytecodeExpressions.constantTrue())).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(type.getJavaType()).pop(type.getJavaType()).gotoLabel(elseLabel));
                test.condition().append((BytecodeNode)wasNullCheck);
            }
            test.condition().append((BytecodeNode)BytecodeUtils.invoke(equalsFunction, OperatorType.EQUAL.name()));
            test.ifTrue().gotoLabel(matchLabel);
            test.ifFalse((BytecodeNode)elseNode);
            elseNode = test;
            elseLabel = testLabel;
        }
        caseBlock.append((BytecodeNode)elseNode);
        return caseBlock;
    }

    static enum SwitchGenerationCase {
        DIRECT_SWITCH,
        HASH_SWITCH,
        SET_CONTAINS;

    }
}

